/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.file.messages.FileDownloadRequest;
import org.apache.ignite.internal.network.file.messages.FileDownloadRequestBuilder;
import org.apache.ignite.internal.network.file.messages.FileDownloadRequestSerializer;
import org.apache.ignite.internal.network.file.messages.Identifier;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class FileDownloadRequestImpl
implements FileDownloadRequest,
Cloneable {
    public static final short GROUP_TYPE = 200;
    public static final short TYPE = 5;
    @IgniteToStringInclude
    private final Identifier identifier;
    @IgniteToStringInclude
    private final UUID transferId;

    private FileDownloadRequestImpl(Identifier identifier, UUID transferId) {
        this.identifier = identifier;
        this.transferId = transferId;
    }

    @Override
    public Identifier identifier() {
        return this.identifier;
    }

    @Override
    public UUID transferId() {
        return this.transferId;
    }

    public MessageSerializer serializer() {
        return FileDownloadRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 200;
    }

    public String toString() {
        return S.toString(FileDownloadRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 5;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileDownloadRequestImpl otherMessage = (FileDownloadRequestImpl)other;
        return Objects.equals(this.identifier, otherMessage.identifier) && Objects.equals(this.transferId, otherMessage.transferId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.identifier, this.transferId);
        return result;
    }

    public FileDownloadRequestImpl clone() {
        try {
            return (FileDownloadRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FileDownloadRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.identifier != null) {
            this.identifier.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.identifier != null) {
            this.identifier.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements FileDownloadRequestBuilder {
        private Identifier identifier;
        private UUID transferId;

        private Builder() {
        }

        @Override
        public FileDownloadRequestBuilder identifier(Identifier identifier) {
            Objects.requireNonNull(identifier, "identifier is not marked @Nullable");
            this.identifier = identifier;
            return this;
        }

        @Override
        public FileDownloadRequestBuilder transferId(UUID transferId) {
            Objects.requireNonNull(transferId, "transferId is not marked @Nullable");
            this.transferId = transferId;
            return this;
        }

        @Override
        public Identifier identifier() {
            return this.identifier;
        }

        @Override
        public UUID transferId() {
            return this.transferId;
        }

        @Override
        public FileDownloadRequest build() {
            return new FileDownloadRequestImpl(Objects.requireNonNull(this.identifier, "identifier is not marked @Nullable"), Objects.requireNonNull(this.transferId, "transferId is not marked @Nullable"));
        }

        @Override
        public FileDownloadRequest buildDeserialized() {
            return new FileDownloadRequestImpl(this.identifier, this.transferId);
        }
    }
}

