/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.network.file.ChunkedFileWriter;
import org.apache.ignite.internal.network.file.TransferredFilesCollector;
import org.apache.ignite.internal.network.file.exception.FileTransferException;
import org.apache.ignite.internal.network.file.messages.FileChunkMessage;
import org.apache.ignite.internal.network.file.messages.FileHeader;
import org.apache.ignite.internal.util.IgniteUtils;

class FileTransferMessagesHandler
implements TransferredFilesCollector {
    private final int filesCount;
    private final Path dir;
    private final AtomicInteger filesComplete = new AtomicInteger(0);
    private final CompletableFuture<List<Path>> result = new CompletableFuture();
    private final Map<String, ChunkedFileWriter> fileNameToWriter = new ConcurrentHashMap<String, ChunkedFileWriter>();

    FileTransferMessagesHandler(List<FileHeader> headers, Path dir) {
        this.filesCount = headers.size();
        this.dir = dir;
        headers.forEach(this::handleFileHeader);
    }

    private void handleFileHeader(FileHeader header) {
        File file = this.createFile(header.name());
        if (header.length() == 0L) {
            this.filesComplete.incrementAndGet();
        } else {
            this.fileNameToWriter.put(header.name(), this.createFileWriter(file, header.length()));
        }
    }

    void handleFileChunk(FileChunkMessage fileChunk) {
        if (this.result.isDone()) {
            throw new IllegalStateException("Received chunked file after result is already done");
        }
        try {
            ChunkedFileWriter writer = this.fileNameToWriter.get(fileChunk.fileName());
            assert (writer != null) : "Received file chunk for unknown file: " + fileChunk.fileName();
            if (writer.write(fileChunk)) {
                this.filesComplete.incrementAndGet();
                this.completeIfAllFilesFinished();
            }
        }
        catch (IOException e) {
            this.handleFileTransferError(e);
        }
    }

    void handleFileTransferError(Throwable error) {
        if (this.result.isDone()) {
            throw new IllegalStateException("Received file transfer error after result is already done");
        }
        this.result.completeExceptionally(error);
        this.closeAllWriters();
    }

    private void completeIfAllFilesFinished() throws IOException {
        if (this.filesCount == this.filesComplete.get()) {
            try (Stream<Path> stream = Files.list(this.dir);){
                this.result.complete(stream.collect(Collectors.toList()));
            }
        }
    }

    @Override
    public CompletableFuture<List<Path>> collectedFiles() {
        return this.result;
    }

    private void closeAllWriters() {
        try {
            IgniteUtils.closeAll(this.fileNameToWriter.values());
        }
        catch (Exception e) {
            throw new FileTransferException("Failed to close file writers", e);
        }
    }

    private ChunkedFileWriter createFileWriter(File file, long expectedFileSize) {
        try {
            return ChunkedFileWriter.open(file, expectedFileSize);
        }
        catch (IOException e) {
            this.handleFileTransferError(e);
            throw new FileTransferException("Failed to open file writer", e);
        }
    }

    private File createFile(String fileName) {
        try {
            return Files.createFile(this.dir.resolve(fileName), new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            this.handleFileTransferError(e);
            throw new FileTransferException("Failed to create file", e);
        }
    }
}

