/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.tx;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.table.KeyValueView;

public class TransactionsExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Statement stmt;
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800/");){
            stmt = conn.createStatement();
            try {
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS accounts (accountNumber INT PRIMARY KEY,firstName VARCHAR,lastName VARCHAR,balance DOUBLE)");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        System.out.println("\nConnecting to server...");
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            KeyValueView accounts = client.tables().table("accounts").keyValueView(AccountKey.class, Account.class);
            AccountKey key = new AccountKey(123);
            accounts.put(null, (Object)key, (Object)new Account("John", "Doe", 1000.0));
            System.out.println("Initial balance: " + ((Account)accounts.get(null, (Object)key)).balance);
            client.transactions().runInTransaction(tx -> {
                Account acct = (Account)accounts.get(tx, (Object)key);
                acct.balance += 200.0;
                accounts.put(tx, (Object)key, (Object)acct);
            });
            System.out.println("Balance after the sync transaction: " + ((Account)accounts.get(null, (Object)key)).balance);
            CompletableFuture future = client.transactions().runInTransactionAsync(tx -> accounts.getAsync(tx, (Object)key).thenCompose(acct -> {
                acct.balance += 300.0;
                return accounts.putAsync(tx, (Object)key, acct);
            }));
            future.join();
            System.out.println("Balance after the async transaction: " + ((Account)accounts.get(null, (Object)key)).balance);
        }
        finally {
            System.out.println("\nDropping the table...");
            conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800/");
            try {
                stmt = conn.createStatement();
                try {
                    stmt.executeUpdate("DROP TABLE IF EXISTS accounts");
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    static class AccountKey {
        int accountNumber;

        AccountKey() {
        }

        AccountKey(int accountNumber) {
            this.accountNumber = accountNumber;
        }
    }

    static class Account {
        String firstName;
        String lastName;
        double balance;

        Account() {
        }

        Account(String firstName, String lastName, double balance) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.balance = balance;
        }
    }
}

