/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.table;

import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.Tuple;

public class TableExample {
    public static void main(String[] args) throws Exception {
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            client.sql().execute("CREATE TABLE IF NOT EXISTS Person (id int primary key,city_id int,name varchar,age int,company varchar)", new Object[0]);
            IgniteTables tableApi = client.tables();
            QualifiedName qualifiedTableName = QualifiedName.parse((String)"PUBLIC.Person");
            Table myTable = tableApi.table(qualifiedTableName);
            RecordView personTableView = myTable.recordView();
            Tuple personTuple = Tuple.create().set("id", (Object)1).set("city_id", (Object)3).set("name", (Object)"John Doe").set("age", (Object)32).set("company", (Object)"Apache");
            personTableView.upsert(null, (Object)personTuple);
            Tuple personIdTuple = Tuple.create().set("id", (Object)1);
            Tuple insertedPerson = (Tuple)personTableView.get(null, (Object)personIdTuple);
            System.out.println("Person name: " + insertedPerson.stringValue("name"));
        }
    }
}

