/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.table;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.table.RecordView;

public class RecordViewPojoExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Statement stmt;
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800/");){
            stmt = conn.createStatement();
            try {
                stmt.executeUpdate("CREATE TABLE accounts (accountNumber INT PRIMARY KEY,firstName     VARCHAR,lastName      VARCHAR,balance       DOUBLE)");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        System.out.println("\nConnecting to server...");
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            RecordView accounts = client.tables().table("accounts").recordView(Account.class);
            System.out.println("\nInserting a record into the 'accounts' table...");
            Account newAccount = new Account(123456, "Val", "Kulichenko", 100.0);
            accounts.insert(null, (Object)newAccount);
            System.out.println("\nRetrieving a record using RecordView API...");
            Account account = (Account)accounts.get(null, (Object)new Account(123456));
            System.out.println("\nRetrieved record:\n    Account Number: " + account.accountNumber + "\n    Owner: " + account.firstName + " " + account.lastName + "\n    Balance: $" + account.balance);
        }
        finally {
            System.out.println("\nDropping the table...");
            conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800/");
            try {
                stmt = conn.createStatement();
                try {
                    stmt.executeUpdate("DROP TABLE accounts");
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    static class Account {
        int accountNumber;
        String firstName;
        String lastName;
        double balance;

        public Account() {
        }

        public Account(int accountNumber) {
            this.accountNumber = accountNumber;
            this.firstName = null;
            this.lastName = null;
            this.balance = 0.0;
        }

        public Account(int accountNumber, String firstName, String lastName, double balance) {
            this.accountNumber = accountNumber;
            this.firstName = firstName;
            this.lastName = lastName;
            this.balance = balance;
        }
    }
}

