/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.table;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Tuple;

public class RecordViewExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Statement stmt;
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800/");){
            stmt = conn.createStatement();
            try {
                stmt.executeUpdate("CREATE TABLE accounts (accountNumber INT PRIMARY KEY,firstName     VARCHAR,lastName      VARCHAR,balance       DOUBLE)");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        System.out.println("\nConnecting to server...");
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            RecordView accounts = client.tables().table("accounts").recordView();
            System.out.println("\nInserting a record into the 'accounts' table...");
            Tuple newAccountTuple = Tuple.create().set("accountNumber", (Object)123456).set("firstName", (Object)"Val").set("lastName", (Object)"Kulichenko").set("balance", (Object)100.0);
            accounts.insert(null, (Object)newAccountTuple);
            System.out.println("\nRetrieving a record using RecordView API...");
            Tuple accountNumberTuple = Tuple.create().set("accountNumber", (Object)123456);
            Tuple accountTuple = (Tuple)accounts.get(null, (Object)accountNumberTuple);
            System.out.println("\nRetrieved record:\n    Account Number: " + accountTuple.intValue("accountNumber") + "\n    Owner: " + accountTuple.stringValue("firstName") + " " + accountTuple.stringValue("lastName") + "\n    Balance: $" + accountTuple.doubleValue("balance"));
        }
        finally {
            System.out.println("\nDropping the table...");
            conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800/");
            try {
                stmt = conn.createStatement();
                try {
                    stmt.executeUpdate("DROP TABLE accounts");
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }
}

