/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.table;

import java.util.Map;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.lang.AsyncCursor;
import org.apache.ignite.lang.Cursor;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.criteria.Condition;
import org.apache.ignite.table.criteria.Criteria;
import org.apache.ignite.table.criteria.Expression;
import org.apache.ignite.tx.Transaction;

public class QueryExample {
    public static void main(String[] args) throws Exception {
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            System.out.println("Creating Person table");
            client.sql().execute("CREATE TABLE IF NOT EXISTS Person (id int primary key,  city varchar,  name varchar,  age int,  company varchar, city_id int);", new Object[0]);
            client.sql().execute("INSERT INTO Person (id, city, name, age, company, city_id) VALUES (1, 'London', 'John Doe', 42, 'Apache', 101);", new Object[0]);
            client.sql().execute("INSERT INTO Person (id, city, name, age, company, city_id) VALUES (2, 'New York', 'Jane Doe', 36, 'Apache', 102);", new Object[0]);
            IgniteTables tablesApi = client.tables();
            Table myTable = tablesApi.table("Person");
            QueryExample.performQueryWithoutTransaction(myTable);
            QueryExample.performQueryWithTransaction(client, myTable);
            QueryExample.performQueryAsync(myTable);
            System.out.println("Dropping Person table.");
            client.sql().execute("DROP TABLE IF EXISTS PERSON;", new Object[0]);
        }
    }

    public static void performQueryWithoutTransaction(Table table) {
        System.out.println("[ Example 1 ] Performing query without transaction");
        try (Cursor cursor = table.keyValueView().query(null, (Criteria)Criteria.and((Expression[])new Expression[]{Criteria.columnValue((String)"name", (Condition)Criteria.equalTo((Comparable)((Object)"John Doe"))), Criteria.columnValue((String)"age", (Condition)Criteria.greaterThan((Comparable)Integer.valueOf(20)))}));){
            while (cursor.hasNext()) {
                QueryExample.printRecord((Map.Entry)cursor.next());
            }
        }
    }

    public static void performQueryWithTransaction(IgniteClient client, Table table) {
        System.out.println("[ Example 2 ] Performing query with transaction");
        Transaction transaction = client.transactions().begin();
        try (Cursor cursor = table.keyValueView().query(transaction, (Criteria)Criteria.and((Expression[])new Expression[]{Criteria.columnValue((String)"name", (Condition)Criteria.equalTo((Comparable)((Object)"John Doe"))), Criteria.columnValue((String)"age", (Condition)Criteria.greaterThan((Comparable)Integer.valueOf(20)))}));){
            while (cursor.hasNext()) {
                QueryExample.printRecord((Map.Entry)cursor.next());
            }
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            throw new RuntimeException("Transaction failed", e);
        }
    }

    public static void performQueryAsync(Table table) {
        System.out.println("[ Example 3 ] Performing asynchronous query");
        AsyncCursor result = (AsyncCursor)table.keyValueView().queryAsync(null, (Criteria)Criteria.and((Expression[])new Expression[]{Criteria.columnValue((String)"name", (Condition)Criteria.equalTo((Comparable)((Object)"John Doe"))), Criteria.columnValue((String)"age", (Condition)Criteria.greaterThan((Comparable)Integer.valueOf(20)))})).join();
        for (Map.Entry tupleTupleEntry : result.currentPage()) {
            QueryExample.printRecord(tupleTupleEntry);
        }
    }

    private static void printRecord(Map.Entry<Tuple, Tuple> record) {
        int personId = record.getKey().intValue("id");
        Tuple personValueTuple = record.getValue();
        String personName = personValueTuple.stringValue("name");
        int personCityId = personValueTuple.intValue("city_id");
        String personCompany = personValueTuple.stringValue("company");
        System.out.println("Record: { id=" + personId + ", name=" + personName + ", cityId= " + personCityId + ", company=" + personCompany + " }");
    }
}

