/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.table;

import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.example.table.Person;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.mapper.TypeConverter;

public class MapperExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            try {
                client.sql().executeScript("CREATE TABLE Person (id int primary key, city varchar, name varchar, age int, company varchar, city_id int)", new Object[0]);
                client.sql().executeScript("INSERT INTO Person (id, city, name, age, company, city_id) VALUES (1, 'London', 'John Doe', 42, 'Apache', 101)", new Object[0]);
                client.sql().executeScript("INSERT INTO Person (id, city, name, age, company, city_id) VALUES (2, 'New York', 'Jane Doe', 36, 'Apache', 102)", new Object[0]);
                Mapper mapper = Mapper.builder(Person.class).automap().map("cityId", "city_id", (TypeConverter)new CityIdConverter()).build();
                RecordView view = client.tables().table("person").recordView(mapper);
                Person myPerson = new Person(2, "2", "John Doe", 40, "Apache");
                view.upsert(null, (Object)myPerson);
            }
            finally {
                System.out.println("Dropping the table...");
                client.sql().executeScript("DROP TABLE Person;", new Object[0]);
            }
        }
    }

    static class CityIdConverter
    implements TypeConverter<String, Integer> {
        CityIdConverter() {
        }

        public String toObjectType(Integer columnValue) {
            return columnValue.toString();
        }

        public Integer toColumnType(String cityId) {
            return Integer.parseInt(cityId);
        }
    }
}

