/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.table;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.table.KeyValueView;

public class KeyValueViewPojoExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Statement stmt;
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800/");){
            stmt = conn.createStatement();
            try {
                stmt.executeUpdate("CREATE TABLE accounts (accountNumber INT PRIMARY KEY,firstName     VARCHAR,lastName      VARCHAR,balance       DOUBLE)");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        System.out.println("\nConnecting to server...");
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            KeyValueView kvView = client.tables().table("accounts").keyValueView(AccountKey.class, Account.class);
            System.out.println("\nInserting a key-value pair into the 'accounts' table...");
            AccountKey key = new AccountKey(123456);
            Account value = new Account("Val", "Kulichenko", 100.0);
            kvView.put(null, (Object)key, (Object)value);
            System.out.println("\nRetrieving a value using KeyValueView API...");
            value = (Account)kvView.get(null, (Object)key);
            System.out.println("\nRetrieved value:\n    Account Number: " + key.accountNumber + "\n    Owner: " + value.firstName + " " + value.lastName + "\n    Balance: $" + value.balance);
        }
        finally {
            System.out.println("\nDropping the table...");
            conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800/");
            try {
                stmt = conn.createStatement();
                try {
                    stmt.executeUpdate("DROP TABLE accounts");
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    static class AccountKey {
        int accountNumber;

        public AccountKey() {
        }

        public AccountKey(int accountNumber) {
            this.accountNumber = accountNumber;
        }
    }

    static class Account {
        String firstName;
        String lastName;
        double balance;

        public Account() {
        }

        public Account(String firstName, String lastName, double balance) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.balance = balance;
        }
    }
}

