/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.structures;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.marshalling.ByteArrayMarshaller;
import org.apache.ignite.marshalling.Marshaller;
import org.gridgain.structure.IgniteMap;
import org.gridgain.structure.MapConfiguration;

public class DistributedMapExample {
    public static void main(String[] args) throws Exception {
        try (IgniteClient client1 = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();
             IgniteClient client2 = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10801"}).build();){
            CompletableFuture mapFuture = client1.structures().getOrCreateMapAsync(MapConfiguration.builder((String)"map1", Integer.class, String.class).distributionZone("ZONENAME").storageProfile("default").build());
            IgniteMap mapFromNode1 = (IgniteMap)mapFuture.get(10L, TimeUnit.SECONDS);
            DistributedMapExample.basicOperationsSync((IgniteMap<Integer, String>)mapFromNode1);
            DistributedMapExample.basicOperationsAsync((IgniteMap<Integer, String>)mapFromNode1);
            ((CompletableFuture)mapFromNode1.putAsync((Object)1, (Object)"val1").thenCompose(prev -> {
                if (prev != null) {
                    throw new RuntimeException("Previous value should be null");
                }
                return mapFromNode1.getAsync((Object)1).thenAccept(newValue -> System.out.println("New value from node 1 after putAsync: " + newValue));
            })).get(10L, TimeUnit.SECONDS);
            IgniteMap mapFromNode2 = client2.structures().getOrCreateMap(MapConfiguration.builder((String)"map1", Integer.class, String.class).distributionZone("ZONENAME").storageProfile("default").build());
            ((CompletableFuture)mapFromNode2.getAsync((Object)1).thenAccept(v -> System.out.println("Before putAsync - node2 get: " + v))).get(10L, TimeUnit.SECONDS);
            ((CompletableFuture)mapFromNode2.putAsync((Object)1, (Object)"val1").thenCompose(prev -> {
                System.out.println("Result of putAsync(previous): " + prev);
                return mapFromNode2.getAsync((Object)1).thenAccept(newValue -> System.out.println("After putAsync - node2 get: " + newValue));
            })).get(10L, TimeUnit.SECONDS);
            CompletableFuture mapFuture2 = client1.structures().getOrCreateMapAsync("map2", (Marshaller)new KeySerializer(), (Marshaller)new ValueSerializer());
            IgniteMap mapWithCustomSerialization = (IgniteMap)mapFuture2.get(10L, TimeUnit.SECONDS);
            KeyClass key1 = new KeyClass("keyStr1", 1);
            ValueClass value1 = new ValueClass(List.of("valStr1"));
            CompletableFuture putFuture = mapWithCustomSerialization.putAsync((Object)key1, (Object)value1);
            ((CompletableFuture)putFuture.thenCompose(prevValue -> {
                if (prevValue != null) {
                    throw new RuntimeException("Previous value should be null");
                }
                return mapWithCustomSerialization.getAsync((Object)key1).thenAccept(valueFromGet -> {
                    if (!Objects.equals(valueFromGet, value1)) {
                        throw new RuntimeException("Values should be equal");
                    }
                    System.out.println("New value after putAsync: " + valueFromGet);
                });
            })).get(10L, TimeUnit.SECONDS);
        }
    }

    private static void basicOperationsSync(IgniteMap<Integer, String> map) {
        map.put((Object)3, (Object)"val3");
        String value = (String)map.get((Object)3);
        System.out.println("Value: " + value);
    }

    private static void basicOperationsAsync(IgniteMap<Integer, String> map) throws ExecutionException, InterruptedException, TimeoutException {
        ((CompletableFuture)map.putAsync((Object)4, (Object)"val4").thenCompose(prev -> {
            if (prev != null) {
                throw new RuntimeException("Previous value should be null");
            }
            return map.getAsync((Object)4).thenAccept(v -> System.out.println("Value after putAsync: " + v));
        })).get(10L, TimeUnit.SECONDS);
    }

    private static class KeySerializer
    implements ByteArrayMarshaller<KeyClass> {
        private KeySerializer() {
        }

        public byte[] marshal(KeyClass object) {
            if (object == null) {
                return null;
            }
            String result = object.integer + ":" + Base64.getEncoder().encodeToString(object.str.getBytes(StandardCharsets.UTF_8));
            return result.getBytes(StandardCharsets.UTF_8);
        }

        public KeyClass unmarshal(byte[] raw) {
            if (raw == null) {
                return null;
            }
            String rawStr = new String(raw, StandardCharsets.UTF_8);
            int index = rawStr.indexOf(58);
            return new KeyClass(new String(Base64.getDecoder().decode(rawStr.substring(index + 1)), StandardCharsets.UTF_8), Integer.parseInt(rawStr.substring(0, index)));
        }
    }

    private static class ValueSerializer
    implements ByteArrayMarshaller<ValueClass> {
        private ValueSerializer() {
        }

        public byte[] marshal(ValueClass object) {
            if (object == null) {
                return null;
            }
            String result = object.list.stream().map(it -> Base64.getEncoder().encodeToString(it.getBytes(StandardCharsets.UTF_8))).collect(Collectors.joining(":"));
            return result.getBytes(StandardCharsets.UTF_8);
        }

        public ValueClass unmarshal(byte[] raw) {
            if (raw == null) {
                return null;
            }
            String[] split = new String(raw, StandardCharsets.UTF_8).split(":");
            return new ValueClass(Arrays.stream(split).map(it -> new String(Base64.getDecoder().decode((String)it), StandardCharsets.UTF_8)).collect(Collectors.toUnmodifiableList()));
        }
    }

    private static class KeyClass {
        private final String str;
        private final Integer integer;

        public KeyClass(String s, Integer i) {
            this.str = s;
            this.integer = i;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyClass)) {
                return false;
            }
            KeyClass keyClass = (KeyClass)o;
            return Objects.equals(this.str, keyClass.str) && Objects.equals(this.integer, keyClass.integer);
        }

        public int hashCode() {
            return Objects.hash(this.str, this.integer);
        }

        public String toString() {
            return "KeyClass{str='" + this.str + "', integer=" + this.integer + "}";
        }
    }

    private static class ValueClass {
        private final List<String> list;

        public ValueClass(List<String> v) {
            this.list = v;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValueClass)) {
                return false;
            }
            ValueClass that = (ValueClass)o;
            return Objects.equals(this.list, that.list);
        }

        public int hashCode() {
            return Objects.hashCode(this.list);
        }

        public String toString() {
            return "ValueClass{list=" + this.list + "}";
        }
    }
}

