/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.streaming;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.table.DataStreamerReceiver;
import org.apache.ignite.table.DataStreamerReceiverContext;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Tuple;

public class TwoTableReceiver
implements DataStreamerReceiver<Tuple, Void, Tuple> {
    public CompletableFuture<List<Tuple>> receive(List<Tuple> page, DataStreamerReceiverContext ctx, Void arg) {
        RecordView customersTable = ctx.ignite().tables().table("Customers").recordView();
        RecordView addressesTable = ctx.ignite().tables().table("Addresses").recordView();
        ArrayList results = new ArrayList(page.size());
        for (Tuple sourceItem : page) {
            Tuple customer = Tuple.create().set("id", (Object)sourceItem.intValue("customerId")).set("name", (Object)sourceItem.stringValue("customerName")).set("addressId", (Object)sourceItem.intValue("addressId"));
            Tuple address = Tuple.create().set("id", (Object)sourceItem.intValue("addressId")).set("street", (Object)sourceItem.stringValue("street")).set("city", (Object)sourceItem.stringValue("city"));
            customersTable.upsert(null, (Object)customer);
            addressesTable.upsert(null, (Object)address);
        }
        return CompletableFuture.completedFuture(results);
    }
}

