/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.streaming;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.SubmissionPublisher;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.example.streaming.TwoTableReceiver;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Tuple;

public class MultiTableDataStreamerExample {
    private static final String DEPLOYMENT_UNIT_NAME = "streamerReceiverExampleUnit";
    private static final String DEPLOYMENT_UNIT_VERSION = "1.0.0";

    public static void main(String[] arg) {
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            CompletableFuture streamerFut;
            DataStreamerReceiverDescriptor desc = DataStreamerReceiverDescriptor.builder(TwoTableReceiver.class).units(new DeploymentUnit[]{new DeploymentUnit(DEPLOYMENT_UNIT_NAME, DEPLOYMENT_UNIT_VERSION)}).build();
            List sourceData = IntStream.range(1, 10).mapToObj(i -> Tuple.create().set("customerId", (Object)i).set("customerName", (Object)("Customer " + i)).set("addressId", (Object)i).set("street", (Object)("Street " + i)).set("city", (Object)("City " + i))).collect(Collectors.toList());
            RecordView customersTableView = client.tables().table("Customers").recordView();
            Function<Tuple, Tuple> keyFunc = sourceItem -> Tuple.create().set("id", (Object)sourceItem.intValue("customerId"));
            Function payloadFunc = Function.identity();
            try (SubmissionPublisher<Tuple> publisher = new SubmissionPublisher<Tuple>();){
                streamerFut = customersTableView.streamData(publisher, desc, keyFunc, payloadFunc, null, null, null);
                for (Tuple item : sourceData) {
                    publisher.submit(item);
                }
            }
            streamerFut.join();
        }
    }
}

