/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.streaming;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.SubmissionPublisher;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.example.streaming.Account;
import org.apache.ignite.table.DataStreamerException;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.RecordView;

public class DetectFailedEntriesExample {
    private static final int ACCOUNTS_COUNT = 10;

    public static void main(String[] arg) {
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            DataStreamerOptions options = DataStreamerOptions.builder().pageSize(1000).perPartitionParallelOperations(1).autoFlushInterval(1000).retryLimit(16).build();
            System.out.println("Creating Accounts table");
            client.sql().execute("CREATE TABLE IF NOT EXISTS ACCOUNTS (id INT PRIMARY KEY, name VARCHAR(255), balance BIGINT, active BOOLEAN);", new Object[0]);
            RecordView view = client.tables().table("Accounts").recordView(Account.class);
            SubmissionPublisher<DataStreamerItem> publisher = new SubmissionPublisher<DataStreamerItem>();
            CompletableFuture streamerFut = view.streamData(publisher, options);
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            try (SubmissionPublisher<DataStreamerItem> submissionPublisher = publisher;){
                view.streamData(publisher, options).exceptionally(e -> {
                    Throwable cause = e.getCause();
                    if (cause instanceof DataStreamerException) {
                        System.out.println("Failed items during background streaming: " + ((DataStreamerException)cause).failedItems());
                    } else {
                        System.out.println("Streaming error: " + cause.getMessage());
                    }
                    return null;
                });
                for (int i = 0; i < 10; ++i) {
                    Account entry = new Account(i, "Account " + i, rnd.nextLong(100000L), rnd.nextBoolean());
                    publisher.submit(DataStreamerItem.of((Object)entry));
                }
            }
            catch (DataStreamerException e2) {
                System.out.println("Failed items during submission: " + e2.failedItems());
            }
            streamerFut.join();
            System.out.println("Dropping Accounts table.");
            client.sql().execute("DROP TABLE IF EXISTS ACCOUNTS;", new Object[0]);
        }
    }
}

