/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.storage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class StorageEngineExample {
    private final String storageProfileName;

    StorageEngineExample(String storageProfileName) {
        this.storageProfileName = storageProfileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() throws SQLException {
        Statement stmt;
        Connection conn;
        System.out.println("\nConnecting to server...");
        try {
            conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800/");
            try {
                stmt = conn.createStatement();
                try {
                    stmt.executeUpdate("CREATE ZONE ACCOUNTS_ZONE  WITH STORAGE_PROFILES='" + this.storageProfileName + "'");
                    stmt.executeUpdate("CREATE TABLE ACCOUNTS ( ACCOUNT_ID INT PRIMARY KEY,FIRST_NAME VARCHAR, LAST_NAME  VARCHAR, BALANCE    DOUBLE) ZONE ACCOUNTS_ZONE");
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                System.out.println("\nPopulating 'ACCOUNTS' table...");
                stmt = conn.prepareStatement("INSERT INTO ACCOUNTS (ACCOUNT_ID, FIRST_NAME, LAST_NAME, BALANCE) values (?, ?, ?, ?)");
                try {
                    stmt.setInt(1, 1);
                    stmt.setString(2, "John");
                    stmt.setString(3, "Doe");
                    stmt.setDouble(4, 1000.0);
                    stmt.executeUpdate();
                    stmt.setInt(1, 2);
                    stmt.setString(2, "Jane");
                    stmt.setString(3, "Roe");
                    stmt.setDouble(4, 2000.0);
                    stmt.executeUpdate();
                    stmt.setInt(1, 3);
                    stmt.setString(2, "Mary");
                    stmt.setString(3, "Major");
                    stmt.setDouble(4, 1500.0);
                    stmt.executeUpdate();
                    stmt.setInt(1, 4);
                    stmt.setString(2, "Richard");
                    stmt.setString(3, "Miles");
                    stmt.setDouble(4, 1450.0);
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                System.out.println("\nAll accounts:");
                stmt = conn.createStatement();
                try (ResultSet rs = stmt.executeQuery("SELECT ACCOUNT_ID, FIRST_NAME, LAST_NAME, BALANCE FROM ACCOUNTS ORDER BY ACCOUNT_ID");){
                    while (rs.next()) {
                        System.out.println("    " + rs.getString(1) + ", " + rs.getString(2) + ", " + rs.getString(3) + ", " + rs.getString(4));
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        finally {
            System.out.println("\nDropping the table...");
            conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800/");
            try {
                stmt = conn.createStatement();
                try {
                    stmt.executeUpdate("DROP TABLE ACCOUNTS");
                    stmt.executeUpdate("DROP ZONE ACCOUNTS_ZONE");
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }
}

