/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.sql.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

public class SqlJdbcExample {
    public static void main(String[] args) throws Exception {
        System.out.println("\nConnecting to server...");
        try (Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800/");){
            ResultSet rs;
            try (Statement stmt = conn.createStatement();){
                stmt.executeUpdate("CREATE TABLE CITIES (ID   INT PRIMARY KEY,NAME VARCHAR)");
                stmt.executeUpdate("CREATE TABLE ACCOUNTS (    ACCOUNT_ID INT PRIMARY KEY,    CITY_ID    INT,    FIRST_NAME VARCHAR,    LAST_NAME  VARCHAR,    BALANCE    DOUBLE)");
            }
            System.out.println("\nPopulating 'CITIES' table...");
            stmt = conn.prepareStatement("INSERT INTO CITIES (ID, NAME) VALUES (?, ?)");
            try {
                stmt.setInt(1, 1);
                stmt.setString(2, "Forest Hill");
                stmt.executeUpdate();
                stmt.setInt(1, 2);
                stmt.setString(2, "Denver");
                stmt.executeUpdate();
                stmt.setInt(1, 3);
                stmt.setString(2, "St. Petersburg");
                stmt.executeUpdate();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            System.out.println("\nPopulating 'ACCOUNTS' table...");
            stmt = conn.prepareStatement("INSERT INTO ACCOUNTS (ACCOUNT_ID, CITY_ID, FIRST_NAME, LAST_NAME, BALANCE) values (?, ?, ?, ?, ?)");
            try {
                stmt.setInt(1, 1);
                stmt.setInt(2, 1);
                stmt.setString(3, "John");
                stmt.setString(4, "Doe");
                stmt.setDouble(5, 1000.0);
                stmt.executeUpdate();
                stmt.setInt(1, 2);
                stmt.setInt(2, 1);
                stmt.setString(3, "Jane");
                stmt.setString(4, "Roe");
                stmt.setDouble(5, 2000.0);
                stmt.executeUpdate();
                stmt.setInt(1, 3);
                stmt.setInt(2, 2);
                stmt.setString(3, "Mary");
                stmt.setString(4, "Major");
                stmt.setDouble(5, 1500.0);
                stmt.executeUpdate();
                stmt.setInt(1, 4);
                stmt.setInt(2, 3);
                stmt.setString(3, "Richard");
                stmt.setString(4, "Miles");
                stmt.setDouble(5, 1450.0);
                stmt.executeUpdate();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            System.out.println("\nAll accounts:");
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery("SELECT a.FIRST_NAME, a.LAST_NAME, c.NAME FROM ACCOUNTS a INNER JOIN CITIES c on c.ID = a.CITY_ID ORDER BY a.ACCOUNT_ID");
                try {
                    while (rs.next()) {
                        System.out.println("    " + rs.getString(1) + ", " + rs.getString(2) + ", " + rs.getString(3));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            System.out.println("\nAccounts with balance lower than 1,500:");
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery("SELECT a.FIRST_NAME, a.LAST_NAME, a.BALANCE FROM ACCOUNTS a WHERE a.BALANCE < 1500.0 ORDER BY a.ACCOUNT_ID");
                try {
                    while (rs.next()) {
                        System.out.println("    " + rs.getString(1) + ", " + rs.getString(2) + ", " + rs.getDouble(3));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            System.out.println("\nDeleting one of the accounts...");
            stmt = conn.prepareStatement("DELETE FROM ACCOUNTS WHERE ACCOUNT_ID = ?");
            try {
                stmt.setInt(1, 1);
                stmt.executeUpdate();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            System.out.println("\nAll accounts:");
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery("SELECT a.FIRST_NAME, a.LAST_NAME, c.NAME FROM ACCOUNTS a INNER JOIN CITIES c on c.ID = a.CITY_ID ORDER BY a.ACCOUNT_ID");
                try {
                    while (rs.next()) {
                        System.out.println("    " + rs.getString(1) + ", " + rs.getString(2) + ", " + rs.getString(3));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            System.out.println("\nDropping the tables...");
            stmt = conn.createStatement();
            try {
                stmt.executeUpdate("DROP TABLE ACCOUNTS");
                stmt.executeUpdate("DROP TABLE CITIES");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }
}

