/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.sql;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.lang.CancelHandle;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.sql.BatchedArguments;
import org.apache.ignite.sql.ResultSet;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionOptions;

public class SqlApiExample {
    public static void main(String[] args) throws Exception {
        System.out.println("\nConnecting to server...");
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            client.sql().executeScript("CREATE TABLE CITIES (ID   INT PRIMARY KEY,NAME VARCHAR);CREATE TABLE ACCOUNTS (    ACCOUNT_ID INT PRIMARY KEY,    CITY_ID    INT,    FIRST_NAME VARCHAR,    LAST_NAME  VARCHAR,    BALANCE    DOUBLE)", new Object[0]);
            System.out.println("\nCreate sequence...");
            client.sql().execute("CREATE SEQUENCE IF NOT EXISTS defaultSequence;", new Object[0]);
            client.sql().execute("CREATE TABLE Person (ID BIGINT DEFAULT NEXTVAL('defaultSequence') PRIMARY KEY, CITY_ID BIGINT, NAME VARCHAR, AGE INT, COMPANY VARCHAR);", new Object[0]);
            System.out.println("\nInsert rows...");
            client.sql().execute("INSERT INTO Person (CITY_ID, NAME, AGE, COMPANY) VALUES (1, 'Alice', 30, 'Google'), (2, 'Bob', 40, 'Meta'), (3, 'Charlie', 25, 'Spotify')", new Object[0]);
            System.out.println("\nQuery rows...");
            try (ResultSet currentResultSet = client.sql().execute("SELECT ID, NAME, AGE, COMPANY FROM Person", new Object[0]);){
                while (currentResultSet.hasNext()) {
                    SqlRow row = (SqlRow)currentResultSet.next();
                    System.out.printf("ID=%d, NAME=%s, AGE=%d, COMPANY=%s%n", row.longValue(0), row.stringValue(1), row.intValue(2), row.stringValue(3));
                }
            }
            System.out.println("\nStarting read-write transaction...");
            Transaction tx = client.transactions().begin(new TransactionOptions().readOnly(false));
            try {
                System.out.println("\nPopulating 'CITIES' table...");
                Statement stmt = client.sql().createStatement("INSERT INTO CITIES (ID, NAME) VALUES (?, ?)");
                long rowsAdded = 0L;
                try (ResultSet rs = client.sql().execute(tx, stmt, new Object[]{1, "Forest Hill"});){
                    rowsAdded += rs.affectedRows();
                }
                rs = client.sql().execute(tx, stmt, new Object[]{2, "Denver"});
                try {
                    rowsAdded += rs.affectedRows();
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                rs = client.sql().execute(tx, stmt, new Object[]{3, "St. Petersburg"});
                try {
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                System.out.println("\nAdded cities: " + (rowsAdded += rs.affectedRows()));
                System.out.println("\nPopulating 'ACCOUNTS' table...");
                rowsAdded = Arrays.stream(client.sql().executeBatch(tx, "INSERT INTO ACCOUNTS (ACCOUNT_ID, CITY_ID, FIRST_NAME, LAST_NAME, BALANCE) values (?, ?, ?, ?, ?)", BatchedArguments.of((Object[])new Object[]{1, 1, "John", "Doe", 1000.0}).add(new Object[]{2, 1, "Jane", "Roe", 2000.0}).add(new Object[]{3, 2, "Mary", "Major", 1500.0}).add(new Object[]{4, 3, "Richard", "Miles", 1450.0}))).sum();
                System.out.println("\nAdded accounts: " + rowsAdded);
                System.out.println("\nCommitting transaction...");
                tx.commit();
            }
            catch (Exception e) {
                tx.rollback();
                throw e;
            }
            System.out.println("\nAll accounts:");
            try (ResultSet rs = client.sql().execute("SELECT a.FIRST_NAME, a.LAST_NAME, c.NAME FROM ACCOUNTS a INNER JOIN CITIES c on c.ID = a.CITY_ID ORDER BY a.ACCOUNT_ID", new Object[0]);){
                while (rs.hasNext()) {
                    SqlRow row = (SqlRow)rs.next();
                    System.out.println("    " + row.stringValue(0) + ", " + row.stringValue(1) + ", " + row.stringValue(2));
                }
            }
            System.out.println("\nAccounts with balance lower than 1,500:");
            Statement statement = client.sql().statementBuilder().query("SELECT a.FIRST_NAME as firstName, a.LAST_NAME as lastName, a.BALANCE FROM ACCOUNTS a WHERE a.BALANCE < 1500.0 ORDER BY a.ACCOUNT_ID").build();
            try (ResultSet rs = client.sql().execute((Transaction)null, Mapper.of(AccountInfo.class), statement, new Object[0]);){
                while (rs.hasNext()) {
                    AccountInfo row = (AccountInfo)rs.next();
                    System.out.println("    " + row.firstName + ", " + row.lastName + ", " + row.balance);
                }
            }
            CancelHandle cancelHandle = CancelHandle.create();
            CancellationToken cancelToken = cancelHandle.token();
            client.sql().executeAsync((Transaction)null, cancelToken, "SELECT a.FIRST_NAME, b.LAST_NAME FROM ACCOUNTS a, ACCOUNTS b, ACCOUNTS c ORDER BY a.ACCOUNT_ID", new Object[0]);
            CompletableFuture cancelled = cancelHandle.cancelAsync();
            cancelled.get(5L, TimeUnit.SECONDS);
            System.out.println("\nIs query cancelled: " + cancelled.isDone());
            System.out.println("\nDeleting one of the accounts...");
            try (ResultSet rs = client.sql().execute("DELETE FROM ACCOUNTS WHERE ACCOUNT_ID = ?", new Object[]{1});){
                System.out.println("\n Removed accounts: " + rs.affectedRows());
            }
            System.out.println("\nAll accounts:");
            Statement stmt = client.sql().statementBuilder().query("SELECT a.FIRST_NAME, a.LAST_NAME, c.NAME FROM ACCOUNTS a INNER JOIN CITIES c on c.ID = a.CITY_ID ORDER BY a.ACCOUNT_ID").pageSize(1).build();
            ((CompletableFuture)client.sql().executeAsync((Transaction)null, stmt, new Object[0]).thenCompose(SqlApiExample::fetchAllRowsInto)).get();
            System.out.println("\nDropping the tables...");
            client.sql().executeScript("DROP TABLE ACCOUNTS;DROP TABLE CITIES;DROP TABLE PERSON", new Object[0]);
        }
    }

    private static CompletionStage<Void> fetchAllRowsInto(AsyncResultSet<SqlRow> resultSet) {
        for (SqlRow row : resultSet.currentPage()) {
            System.out.println("    " + row.stringValue(0) + ", " + row.stringValue(1) + ", " + row.stringValue(2));
        }
        if (!resultSet.hasMorePages()) {
            return CompletableFuture.completedFuture(null);
        }
        return resultSet.fetchNextPage().thenCompose(SqlApiExample::fetchAllRowsInto);
    }

    private static class AccountInfo {
        String firstName;
        String lastName;
        double balance;

        private AccountInfo() {
        }
    }
}

