/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.ignite.example.serialization.JsonResult;
import org.apache.ignite.marshalling.Marshaller;

class JsonResultMarshaller
implements Marshaller<JsonResult, byte[]> {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    JsonResultMarshaller() {
    }

    public byte[] marshal(JsonResult o) {
        try {
            return MAPPER.writeValueAsBytes((Object)o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonResult unmarshal(byte[] raw) {
        try {
            return (JsonResult)MAPPER.readValue(raw, JsonResult.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

