/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.ignite.example.serialization.JsonArg;
import org.apache.ignite.marshalling.Marshaller;

class JsonArgMarshaller
implements Marshaller<JsonArg, byte[]> {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    JsonArgMarshaller() {
    }

    public byte[] marshal(JsonArg o) {
        try {
            return MAPPER.writeValueAsBytes((Object)o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonArg unmarshal(byte[] raw) {
        try {
            return (JsonArg)MAPPER.readValue(raw, JsonArg.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

