/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.serialization;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.example.serialization.JsonArg;
import org.apache.ignite.example.serialization.JsonArgMarshaller;
import org.apache.ignite.example.serialization.JsonResult;
import org.apache.ignite.example.serialization.JsonResultMarshaller;
import org.apache.ignite.marshalling.Marshaller;

public class CustomPojoSerializationJob
implements ComputeJob<JsonArg, JsonResult> {
    public CompletableFuture<JsonResult> executeAsync(JobExecutionContext ctx, JsonArg arg) {
        if (arg == null) {
            return null;
        }
        String w = arg.word;
        boolean upper = arg.isUpperCase;
        JsonResult r = new JsonResult();
        r.originalWord = w;
        r.resultWord = upper ? w.toUpperCase() : w.toLowerCase();
        r.length = w.length();
        return CompletableFuture.completedFuture(r);
    }

    public Marshaller<JsonArg, byte[]> inputMarshaller() {
        return new JsonArgServerMarshaller();
    }

    public Marshaller<JsonResult, byte[]> resultMarshaller() {
        return new JsonResultServerMarshaller();
    }

    private static class JsonArgServerMarshaller
    extends JsonArgMarshaller {
        private JsonArgServerMarshaller() {
        }
    }

    private static class JsonResultServerMarshaller
    extends JsonResultMarshaller {
        private JsonResultServerMarshaller() {
        }
    }
}

