/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.compute.JobDescriptor;
import org.apache.ignite.compute.JobTarget;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.example.serialization.CustomPojoSerializationJob;
import org.apache.ignite.example.serialization.JsonArg;
import org.apache.ignite.example.serialization.JsonArgMarshaller;
import org.apache.ignite.example.serialization.JsonResult;
import org.apache.ignite.marshalling.Marshaller;

public class CustomPojoSerializationExample {
    public static final String DEPLOYMENT_UNIT_NAME = "customPojoSerializationExampleUnit";
    public static final String DEPLOYMENT_UNIT_VERSION = "1.0.0";

    static void runPojoCustomJsonSerialization(IgniteClient client) {
        System.out.println("\n[POJO custom] Running POJO job with custom JSON marshallers both on the client and on the server");
        JobDescriptor job = JobDescriptor.builder(CustomPojoSerializationJob.class).argumentMarshaller((Marshaller)new JsonArgMarshaller()).resultMarshaller((Marshaller)new JsonResultMarshaller()).units(new DeploymentUnit[]{new DeploymentUnit(DEPLOYMENT_UNIT_NAME, DEPLOYMENT_UNIT_VERSION)}).build();
        JsonResult res = (JsonResult)client.compute().execute(JobTarget.anyNode((Collection)client.cluster().nodes()), job, (Object)new JsonArg("ignite", false));
        System.out.printf("[POJO custom] original=%s, result=%s, length=%d%n", res.originalWord, res.resultWord, res.length);
    }

    private static class JsonResultMarshaller
    implements Marshaller<JsonResult, byte[]> {
        private static final ObjectMapper MAPPER = new ObjectMapper();

        private JsonResultMarshaller() {
        }

        public byte[] marshal(JsonResult o) {
            try {
                return MAPPER.writeValueAsBytes((Object)o);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public JsonResult unmarshal(byte[] raw) {
            try {
                return (JsonResult)MAPPER.readValue(raw, JsonResult.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

