/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.near.cache;

import java.nio.file.Path;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteServer;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.NearCacheOptions;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.TableViewOptions;
import org.apache.ignite.table.Tuple;

public class NearCacheExample {
    public static void demonstrateNearCacheClient() throws Exception {
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            NearCacheOptions nearCacheOptions = NearCacheOptions.builder().expireAfterAccess(5000).expireAfterUpdate(100000).maxEntries(100L).build();
            TableViewOptions tableViewOptions = TableViewOptions.builder().nearCacheOptions(nearCacheOptions).build();
            QualifiedName myTable = QualifiedName.parse((String)"PUBLIC.accounts");
            try (KeyValueView kvView = client.tables().table(myTable).keyValueView(tableViewOptions);){
                Tuple key = Tuple.create().set("id", (Object)0);
                Tuple value = (Tuple)kvView.get(null, (Object)key);
                System.out.println("Retrieved value:" + value.intValue("id"));
            }
        }
    }

    public static void demonstrateNearCacheEmbedded() throws Exception {
        Path myConfig = Path.of("conf/gridgain-config.conf", new String[0]);
        Path myWorkDir = Path.of("/home/gridgain", new String[0]);
        IgniteServer node = IgniteServer.start((String)"node", (Path)myConfig, (Path)myWorkDir);
        Ignite ignite = node.api();
        NearCacheOptions nearCacheOptions = NearCacheOptions.builder().expireAfterAccess(5000).expireAfterUpdate(100000).maxEntries(100L).updatePollInterval(1000).build();
        TableViewOptions tableViewOptions = TableViewOptions.builder().nearCacheOptions(nearCacheOptions).build();
        QualifiedName myTable = QualifiedName.parse((String)"PUBLIC.accounts");
        try (KeyValueView kvView = ignite.tables().table(myTable).keyValueView(tableViewOptions);){
            Tuple key = Tuple.create().set("id", (Object)0);
            Tuple value = (Tuple)kvView.get(null, (Object)key);
            System.out.println("Retrieved value:" + value.intValue("id"));
        }
    }

    public static void main(String[] args) throws Exception {
        NearCacheExample.demonstrateNearCacheClient();
        NearCacheExample.demonstrateNearCacheEmbedded();
    }
}

