/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.ml.custom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.ignite.marshalling.ByteArrayMarshaller;
import org.apache.ignite.marshalling.MarshallingException;
import org.apache.ignite.marshalling.UnmarshallingException;

public class CustomOutputMarshaller<O>
implements ByteArrayMarshaller<O>,
Serializable {
    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] marshal(O obj) throws MarshallingException {
        if (obj != null) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    oos.writeObject(obj);
                    oos.flush();
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new MarshallingException("Failed to marshal Output", (Throwable)e);
            }
        }
        return new byte[0];
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public O unmarshal(byte[] data) throws UnmarshallingException {
        if (data != null) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
                Object object;
                try (ObjectInputStream ois = new ObjectInputStream(bais);){
                    object = ois.readObject();
                }
                return (O)object;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new UnmarshallingException("Failed to unmarshal Output", (Throwable)e);
            }
        }
        return null;
    }
}

