/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.ml.custom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.ignite.marshalling.ByteArrayMarshaller;
import org.apache.ignite.marshalling.MarshallingException;
import org.apache.ignite.marshalling.UnmarshallingException;
import org.gridgain.ml.model.MlJobParameters;

public class CustomInputMarshaller<I extends MlJobParameters>
implements ByteArrayMarshaller<I>,
Serializable {
    private static final long serialVersionUID = 4665080653002149053L;

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] marshal(I obj) throws MarshallingException {
        Objects.requireNonNull(obj, "Input object cannot be null");
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(obj);
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (Throwable e) {
            throw new MarshallingException("Failed to marshal MlJobParameters", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public I unmarshal(byte[] data) throws UnmarshallingException {
        if (data == null) {
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            MlJobParameters mlJobParameters;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                mlJobParameters = (MlJobParameters)ois.readObject();
            }
            return (I)mlJobParameters;
        }
        catch (Throwable e) {
            throw new UnmarshallingException("Failed to unmarshal MlJobParameters", e);
        }
    }
}

