/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.ml;

import ai.djl.MalformedModelException;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Progress;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ModelUtils {
    static Path downloadAndDeployModelAndJar(List<String> urls, String modelId, String modelVersion, Path sourceDir) throws IOException, ExecutionException, InterruptedException {
        Path tempModelDir = Files.createTempDirectory("ml-model-" + modelId + "-", new FileAttribute[0]);
        System.out.println("Created temporary directory for model: " + tempModelDir);
        ModelUtils.downloadModelFiles(urls, tempModelDir.toString());
        Path builtJar = ModelUtils.findExamplesJar();
        Path jarPath = tempModelDir.resolve("custom-classes.jar");
        Files.copy(builtJar, jarPath, StandardCopyOption.REPLACE_EXISTING);
        System.out.println("Copied pre-built examples JAR: " + builtJar);
        ModelUtils.deployModel(modelId, modelVersion, tempModelDir.toString());
        System.out.println("Model and JAR downloaded and deployed from temp directory");
        return tempModelDir;
    }

    private static Path findExamplesJar() throws IOException {
        List<Path> possibleDirs = List.of(Paths.get("build/libs", new String[0]), Paths.get("examples/java/build/libs", new String[0]), Paths.get("../examples/java/build/libs", new String[0]));
        String prefix = System.getProperty("examples.jar.prefix", "example-ml");
        for (Path dir : possibleDirs) {
            if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) continue;
            Stream<Path> files = Files.list(dir);
            try {
                Optional<Path> jar = files.filter(path -> path.getFileName().toString().startsWith(prefix)).filter(path -> path.getFileName().toString().endsWith(".jar")).filter(path -> !path.getFileName().toString().contains("-sources")).filter(path -> !path.getFileName().toString().contains("-javadoc")).filter(path -> !path.getFileName().toString().contains("-tests")).findFirst();
                if (!jar.isPresent()) continue;
                Path path2 = jar.get();
                return path2;
            }
            finally {
                if (files == null) continue;
                files.close();
            }
        }
        throw new IOException("Could not find a valid examples JAR (prefix: " + prefix + "). Please run './gradlew build'.");
    }

    static <I, O> Path downloadAndDeployDJLModelAndJar(String modelUrl, Class<I> inputClass, Class<O> outputClass, String modelId, String modelVersion, Path sourceDir, String translatorFactoryClassName) throws IOException, ExecutionException, InterruptedException, ModelNotFoundException, MalformedModelException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Path tempModelDir = Files.createTempDirectory("ml-model-" + modelId + "-", new FileAttribute[0]);
        System.out.println("Created temporary directory for model: " + tempModelDir);
        ModelUtils.downloadDjlModel(modelUrl, inputClass, outputClass, tempModelDir.toString(), translatorFactoryClassName);
        Path builtJar = ModelUtils.findExamplesJar();
        Path jarPath = tempModelDir.resolve("custom-classes.jar");
        Files.copy(builtJar, jarPath, StandardCopyOption.REPLACE_EXISTING);
        System.out.println("Copied pre-built examples JAR: " + builtJar);
        ModelUtils.deployModel(modelId, modelVersion, tempModelDir.toString());
        System.out.println("Model and JAR downloaded and deployed from temp directory");
        return tempModelDir;
    }

    static <I, O> Path downloadAndDeployModelAndJarWithFolderStructure(List<String> urls, String modelId, String modelVersion, Path sourceDir) throws IOException {
        Path tempModelDir = Files.createTempDirectory("ml-model-" + modelId + "-", new FileAttribute[0]);
        System.out.println("Created temporary directory for model: " + tempModelDir);
        ModelUtils.downloadModelFilesWithFolderStructure(urls, tempModelDir.toString());
        Path builtJar = ModelUtils.findExamplesJar();
        Path jarPath = tempModelDir.resolve("custom-classes.jar");
        Files.copy(builtJar, jarPath, StandardCopyOption.REPLACE_EXISTING);
        System.out.println("Copied pre-built examples JAR: " + builtJar);
        ModelUtils.deployModelWithFolderStructure(modelId, modelVersion, tempModelDir.toString());
        System.out.println("Model and JAR downloaded and deployed from temp directory");
        return tempModelDir;
    }

    static <I, O> Path downloadAndDeployDjlModel(String modelUrl, Class<I> inputClass, Class<O> outputClass, String modelId, String modelVersion, String translatorFactoryClassName) throws IOException, ModelNotFoundException, MalformedModelException, ExecutionException, InterruptedException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Path tempModelDir = Files.createTempDirectory("ml-model-" + modelId + "-", new FileAttribute[0]);
        System.out.println("Created temporary directory for model: " + tempModelDir);
        ModelUtils.downloadDjlModel(modelUrl, inputClass, outputClass, tempModelDir.toString(), translatorFactoryClassName);
        ModelUtils.deployModel(modelId, modelVersion, tempModelDir.toString());
        System.out.println("Model downloaded and deployed from temp directory");
        return tempModelDir;
    }

    public static <I, O> void downloadDjlModel(String modelUrl, Class<I> inputClass, Class<O> outputClass, String targetDirectory, String translatorFactoryClassName) throws IOException, ModelNotFoundException, MalformedModelException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> factoryClass = Class.forName(translatorFactoryClassName);
        TranslatorFactory factory = (TranslatorFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Criteria criteria = Criteria.builder().optModelUrls(modelUrl).setTypes(inputClass, outputClass).optTranslatorFactory(factory).optProgress((Progress)new ProgressBar()).build();
        System.out.println("Loading model...");
        try (ZooModel model = criteria.loadModel();){
            Path modelPath = model.getModelPath();
            System.out.println("Model loaded from: " + modelPath);
            Path targetDir = Paths.get(targetDirectory, new String[0]);
            Files.createDirectories(targetDir, new FileAttribute[0]);
            System.out.println("Copying model files to: " + targetDir);
            ModelUtils.copyDirectory(modelPath, targetDir);
            System.out.println("Model downloaded successfully to: " + targetDir);
        }
    }

    private static void downloadModelFiles(List<String> urls, String localPath) throws IOException {
        Path directory = Paths.get(localPath, new String[0]);
        Files.createDirectories(directory, new FileAttribute[0]);
        int successCount = 0;
        int failCount = 0;
        for (int i = 0; i < urls.size(); ++i) {
            String urlString = urls.get(i);
            String fileName = ModelUtils.extractFileName(urlString);
            Path destination = directory.resolve(fileName);
            System.out.println("\n[" + (i + 1) + "/" + urls.size() + "] Downloading " + fileName);
            try {
                ModelUtils.downloadFile(urlString, destination);
                ++successCount;
                continue;
            }
            catch (IOException e) {
                System.err.println("Failed to download " + fileName + ": " + e.getMessage());
                ++failCount;
            }
        }
        System.out.println("\n=== Download Summary ===");
        System.out.println("Success: " + successCount + "/" + urls.size());
        if (failCount > 0) {
            System.out.println("Failed: " + failCount + "/" + urls.size());
        }
    }

    private static void deployModel(String modelId, String modelVersion, String localModelPath) throws InterruptedException, ExecutionException {
        System.out.println("Starting Embedded Server Model Deployment");
        ModelUtils.waitForServerReadiness();
        boolean deploymentSuccess = ModelUtils.deployModelFromLocalPath(modelId, modelVersion, localModelPath).get();
        if (deploymentSuccess) {
            System.out.println("Model deployment completed successfully!");
        } else {
            System.err.println("Model deployment failed!");
        }
    }

    private static void waitForServerReadiness() throws InterruptedException {
        System.out.println("Waiting for port to be available...");
        for (int i = 0; i < 60; ++i) {
            try (Socket socket = new Socket();){
                socket.connect(new InetSocketAddress("localhost", 10300), 2000);
                System.out.println("Port 10300 is available");
                Thread.sleep(5000L);
                System.out.println("Server should be ready for REST API calls");
                return;
            }
            catch (IOException e) {
                System.out.println("Port 10300 not ready, waiting... (" + (i + 1) + "/60)");
                Thread.sleep(1000L);
                continue;
            }
        }
        throw new RuntimeException("Port did not become available within 60 seconds");
    }

    private static void downloadFile(String urlString, Path destination) throws IOException {
        URL url = new URL(urlString);
        try (InputStream in = url.openStream();){
            Files.copy(in, destination, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Saved to: " + destination);
        }
    }

    private static CompletableFuture<Boolean> deployModelFromLocalPath(Object modelId, Object modelVersion, String localModelPath) {
        System.out.println("Deploying model from local path...");
        System.out.println("   Model ID: " + modelId);
        System.out.println("   Version: " + modelVersion);
        System.out.println("   Source Path: " + localModelPath);
        System.out.println("   Deploy Mode: MAJORITY");
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path modelPath = Paths.get(localModelPath, new String[0]);
                if (!Files.exists(modelPath, new LinkOption[0]) || !Files.isDirectory(modelPath, new LinkOption[0])) {
                    throw new RuntimeException("Model directory does not exist: " + modelPath);
                }
                System.out.println("   Model files to deploy:");
                Files.list(modelPath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    try {
                        long size = Files.size(file);
                        System.out.printf("      %s (%d bytes)%n", file.getFileName(), size);
                    }
                    catch (IOException e) {
                        System.err.println("      " + file.getFileName() + " (size unknown)");
                    }
                });
                String boundary = "----GridGainModelBoundary" + System.currentTimeMillis();
                byte[] requestBody = ModelUtils.createMultipartRequestBody(modelPath, boundary);
                String deploymentUrl = String.format("http://localhost:10300/management/v1/deployment/units/%s/%s?deployMode=MAJORITY", modelId, modelVersion);
                System.out.println("Deployment URL: " + deploymentUrl);
                System.out.println("Uploading model files...");
                HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(60L)).build();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(deploymentUrl)).header("Content-Type", "multipart/form-data; boundary=" + boundary).POST(HttpRequest.BodyPublishers.ofByteArray(requestBody)).timeout(Duration.ofMinutes(10L)).build();
                HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                System.out.println("Response Status: " + response.statusCode());
                if (response.statusCode() == 200 || response.statusCode() == 201) {
                    System.out.println("Model deployed successfully!");
                    return true;
                }
                if (response.statusCode() == 409) {
                    System.out.println("Model already exists, deployment skipped");
                    return true;
                }
                System.err.println("Deployment failed!");
                System.err.println("Response: " + response.body());
                return false;
            }
            catch (Throwable e) {
                System.err.println("Deployment error: " + e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    private static byte[] createMultipartRequestBody(Path modelPath, String boundary) throws IOException {
        ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
        Files.list(modelPath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
            try {
                String fileName = file.getFileName().toString();
                byte[] fileContent = Files.readAllBytes(file);
                String contentType = ModelUtils.determineContentType(fileName);
                bodyStream.write(("--" + boundary + "\r\n").getBytes("UTF-8"));
                bodyStream.write(("Content-Disposition: form-data; name=\"unitContent\"; filename=\"" + fileName + "\"\r\n").getBytes("UTF-8"));
                bodyStream.write(("Content-Type: " + contentType + "\r\n").getBytes("UTF-8"));
                bodyStream.write("\r\n".getBytes("UTF-8"));
                bodyStream.write(fileContent);
                bodyStream.write("\r\n".getBytes("UTF-8"));
                System.out.printf("      Packaged: %s (%d bytes)%n", fileName, fileContent.length);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read file: " + file, e);
            }
        });
        bodyStream.write(("--" + boundary + "--\r\n").getBytes("UTF-8"));
        return bodyStream.toByteArray();
    }

    private static String determineContentType(String fileName) {
        String lower = fileName.toLowerCase();
        if (lower.endsWith(".json")) {
            return "application/json";
        }
        if (lower.endsWith(".txt")) {
            return "text/plain";
        }
        if (lower.endsWith(".pt") || lower.endsWith(".pth")) {
            return "application/octet-stream";
        }
        if (lower.endsWith(".onnx")) {
            return "application/octet-stream";
        }
        if (lower.endsWith(".pb")) {
            return "application/octet-stream";
        }
        if (lower.endsWith(".bin")) {
            return "application/octet-stream";
        }
        return "application/octet-stream";
    }

    private static String extractFileName(String urlString) {
        try {
            URI uri = new URI(urlString);
            String path = uri.getPath();
            if (path == null || path.isEmpty()) {
                return "";
            }
            Path fileName = Paths.get(path, new String[0]).getFileName();
            return fileName != null ? fileName.toString() : "";
        }
        catch (Exception e) {
            int idx = urlString.lastIndexOf(47);
            if (idx >= 0 && idx < urlString.length() - 1) {
                String afterSlash = urlString.substring(idx + 1);
                int qIdx = afterSlash.indexOf(63);
                if (qIdx >= 0) {
                    return afterSlash.substring(0, qIdx);
                }
                return afterSlash;
            }
            return "";
        }
    }

    private static void copyDirectory(Path source, Path target) throws IOException {
        Files.createDirectories(target, new FileAttribute[0]);
        Files.list(source).forEach(path -> {
            try {
                Path targetPath = target.resolve(source.relativize((Path)path));
                if (Files.isDirectory(path, new LinkOption[0])) {
                    ModelUtils.copyDirectory(path, targetPath);
                } else {
                    Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    System.out.println("  Copied: " + targetPath.getFileName());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy: " + path, e);
            }
        });
    }

    private static void downloadModelFilesWithFolderStructure(List<String> urls, String localPath) {
        try {
            Path directory = Paths.get(localPath, new String[0]);
            Files.createDirectories(directory, new FileAttribute[0]);
            int successCount = 0;
            int failCount = 0;
            for (int i = 0; i < urls.size(); ++i) {
                String urlString = urls.get(i);
                String fileName = ModelUtils.extractFileNameWithPath(urlString);
                Path destination = directory.resolve(fileName);
                Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                System.out.println("\n[" + (i + 1) + "/" + urls.size() + "] Downloading " + fileName);
                try {
                    ModelUtils.downloadFile(urlString, destination);
                    ++successCount;
                    continue;
                }
                catch (IOException e) {
                    System.err.println("Failed to download " + fileName + ": " + e.getMessage());
                    ++failCount;
                }
            }
            System.out.println("\n=== Download Summary ===");
            System.out.println("Success: " + successCount + "/" + urls.size());
            if (failCount > 0) {
                System.out.println("Failed: " + failCount + "/" + urls.size());
            }
        }
        catch (Throwable e) {
            System.err.println("Error downloading model: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static void deployModelWithFolderStructure(String modelId, String modelVersion, String localModelPath) {
        try {
            System.out.println("Starting Embedded Server Model Deployment with folder structure support");
            ModelUtils.waitForServerReadiness();
            boolean deploymentSuccess = ModelUtils.deployModelWithUnzipSupport(modelId, modelVersion, localModelPath).get();
            if (deploymentSuccess) {
                System.out.println("Model deployment completed successfully!");
            } else {
                System.err.println("Model deployment failed!");
            }
        }
        catch (Throwable e) {
            System.err.println("Deployment failed: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static CompletableFuture<Boolean> deployModelWithUnzipSupport(Object modelId, Object modelVersion, String localModelPath) {
        System.out.println("Deploying model from local path with folder structure support...");
        System.out.println("   Model ID: " + modelId);
        System.out.println("   Version: " + modelVersion);
        System.out.println("   Source Path: " + localModelPath);
        System.out.println("   Deploy Mode: MAJORITY");
        System.out.println("   X-Unzip-Units: true");
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path modelPath = Paths.get(localModelPath, new String[0]);
                if (!Files.exists(modelPath, new LinkOption[0])) throw new RuntimeException("Model directory does not exist: " + modelPath);
                if (!Files.isDirectory(modelPath, new LinkOption[0])) {
                    throw new RuntimeException("Model directory does not exist: " + modelPath);
                }
                Path zipFile = ModelUtils.createModelZip(modelPath);
                System.out.println("Created temporary ZIP file: " + zipFile);
                try {
                    String boundary = "----GridGainModelBoundary" + System.currentTimeMillis();
                    byte[] requestBody = ModelUtils.createZipMultipartRequestBody(zipFile, boundary);
                    String deploymentUrl = String.format("http://localhost:10300/management/v1/deployment/units/zip/%s/%s?deployMode=MAJORITY", modelId, modelVersion);
                    System.out.println("Deployment URL: " + deploymentUrl);
                    System.out.println("Uploading model ZIP file with folder structure...");
                    HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(60L)).build();
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create(deploymentUrl)).header("Content-Type", "multipart/form-data; boundary=" + boundary).header("X-Unzip-Units", "true").POST(HttpRequest.BodyPublishers.ofByteArray(requestBody)).timeout(Duration.ofMinutes(10L)).build();
                    HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                    System.out.println("Response Status: " + response.statusCode());
                    if (response.statusCode() == 200 || response.statusCode() == 201) {
                        System.out.println("Model deployed successfully with folder structure!");
                        Boolean bl = true;
                        return bl;
                    }
                    if (response.statusCode() == 409) {
                        System.out.println("Model already exists, deployment skipped");
                        Boolean bl = true;
                        return bl;
                    }
                    System.err.println("Deployment failed!");
                    System.err.println("Response: " + response.body());
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        Files.deleteIfExists(zipFile);
                        System.out.println("Cleaned up temporary ZIP file");
                    }
                    catch (IOException e) {
                        System.err.println("Warning: Could not delete temporary ZIP file: " + e.getMessage());
                    }
                }
            }
            catch (Throwable e) {
                System.err.println("Deployment error: " + e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    private static Path createModelZip(Path modelDirectory) throws IOException {
        Path tempZip = Files.createTempFile("model-deployment-", ".zip", new FileAttribute[0]);
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(tempZip, new OpenOption[0]));){
            Files.walk(modelDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    Path relativePath = modelDirectory.relativize((Path)file);
                    String zipEntryName = relativePath.toString().replace('\\', '/');
                    ZipEntry zipEntry = new ZipEntry(zipEntryName);
                    zos.putNextEntry(zipEntry);
                    Files.copy(file, zos);
                    zos.closeEntry();
                    System.out.printf("      Added to ZIP: %s (%d bytes)%n", zipEntryName, Files.size(file));
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to add file to ZIP: " + file, e);
                }
            });
        }
        System.out.printf("Created ZIP file: %s (%d bytes)%n", tempZip.getFileName(), Files.size(tempZip));
        return tempZip;
    }

    private static byte[] createZipMultipartRequestBody(Path zipFile, String boundary) throws IOException {
        ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
        String fileName = zipFile.getFileName().toString();
        byte[] fileContent = Files.readAllBytes(zipFile);
        bodyStream.write(("--" + boundary + "\r\n").getBytes("UTF-8"));
        bodyStream.write(("Content-Disposition: form-data; name=\"unitContent\"; filename=\"" + fileName + "\"\r\n").getBytes("UTF-8"));
        bodyStream.write("Content-Type: application/zip\r\n".getBytes("UTF-8"));
        bodyStream.write("\r\n".getBytes("UTF-8"));
        bodyStream.write(fileContent);
        bodyStream.write("\r\n".getBytes("UTF-8"));
        bodyStream.write(("--" + boundary + "--\r\n").getBytes("UTF-8"));
        System.out.printf("Created multipart request body with ZIP file (%d bytes)%n", fileContent.length);
        return bodyStream.toByteArray();
    }

    private static String extractFileNameWithPath(String urlString) {
        String url = urlString.split("\\?")[0];
        String[] pathParts = url.split("/");
        for (int i = pathParts.length - 2; i >= 0; --i) {
            if (!"variables".equals(pathParts[i]) && !"assets".equals(pathParts[i]) && !"checkpoints".equals(pathParts[i])) continue;
            return String.join((CharSequence)"/", Arrays.copyOfRange(pathParts, i, pathParts.length));
        }
        return pathParts[pathParts.length - 1];
    }

    static void deleteDirectory(Path dir) throws IOException {
        if (Files.exists(dir, new LinkOption[0])) {
            Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    System.err.println("Failed to delete: " + path);
                }
            });
        }
    }
}

