/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.ml;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.ignite.IgniteServer;
import org.apache.ignite.InitParameters;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.sql.IgniteSql;
import org.gridgain.ml.IgniteMl;

public class MlBaseExample {
    private static final String CONFIG_FILE_PATH = System.getenv("GRIDGAIN_HOME") + "/etc/gridgain-config.conf";
    private static final String LICENSE_FILE_PATH = System.getenv("GRIDGAIN_HOME") + "/license/license.conf";
    private static final String WORK_FOLDER_PATH = "work";
    protected static IgniteServer server;
    protected static IgniteClient client;
    protected static IgniteMl mlApi;
    protected static IgniteSql sql;

    protected static void start(MODE mode) {
        switch (mode) {
            case EMBEDDED: {
                MlBaseExample.setupServer();
                break;
            }
            case CLIENT_ONLY: {
                MlBaseExample.setupClient();
                break;
            }
            default: {
                System.err.println("Unsupported execution mode: " + mode);
                throw new UnsupportedOperationException("Unsupported execution mode: " + mode);
            }
        }
    }

    private static void setupClient() {
        System.out.println("Setting up client connection for ML_EMBEDDED compute...");
        client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();
        mlApi = client.ml();
        sql = client.sql();
        System.out.println("Client connection established");
    }

    private static void setupServer() {
        System.out.println("Starting the server");
        try {
            Path myConfig = Path.of(CONFIG_FILE_PATH, new String[0]);
            Path myLicense = Path.of(LICENSE_FILE_PATH, new String[0]);
            Path myWorkDir = Path.of(WORK_FOLDER_PATH, new String[0]);
            if (!Files.exists(myConfig, new LinkOption[0])) {
                throw new RuntimeException("Config file not found at " + myConfig);
            }
            if (!Files.exists(myLicense, new LinkOption[0])) {
                throw new RuntimeException("License file not found at " + myLicense);
            }
            server = IgniteServer.start((String)"defaultNode", (Path)myConfig, (Path)myWorkDir);
            String myLicenseStr = Files.readString(myLicense);
            InitParameters initParameters = InitParameters.builder().metaStorageNodeNames(new String[]{"defaultNode"}).clusterName("cluster").clusterConfiguration(myLicenseStr).build();
            server.initCluster(initParameters);
            mlApi = server.api().ml();
            sql = server.api().sql();
            System.out.println("Example completed successfully!");
        }
        catch (Throwable e) {
            System.err.println("Example failed: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    protected static void stop() {
        System.out.println("Cleaning up and shutting down");
        try {
            if (client != null) {
                client.close();
                System.out.println("  Client connection closed");
            }
            if (server != null) {
                server.shutdown();
                System.out.println("GridGain server shut down successfully");
            }
            System.out.println("Cleanup and shutdown Completed");
        }
        catch (Throwable e) {
            System.err.println("Error during cleanup");
            throw e;
        }
    }

    protected static enum MODE {
        EMBEDDED,
        CLIENT_ONLY;

    }
}

