/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.cq;

import java.util.List;
import java.util.concurrent.Flow;
import org.apache.ignite.table.TableRowEvent;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.Tuple;

public class SubscriberExample
implements Flow.Subscriber<TableRowEventBatch<Tuple>> {
    private volatile Flow.Subscription subscription;

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(TableRowEventBatch<Tuple> batch) {
        List items = batch.rows();
        for (TableRowEvent item : items) {
            System.out.println("onNext: " + item.type() + ", old=" + item.oldEntry() + ", new=" + item.entry());
        }
    }

    @Override
    public void onError(Throwable throwable) {
        System.out.println("onError: " + throwable);
    }

    @Override
    public void onComplete() {
        System.out.println("onComplete");
    }

    void cancel() {
        Flow.Subscription sub = this.subscription;
        if (sub != null) {
            sub.cancel();
        }
    }
}

