/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.cq;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.example.cq.SubscriberExample;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Tuple;

public class CQexample {
    public static void main(String[] args) throws Exception {
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            client.sql().execute("DROP TABLE IF EXISTS PERSON;", new Object[0]);
            client.sql().execute("CREATE TABLE IF NOT EXISTS PERSON (ID INT PRIMARY KEY, NAME VARCHAR, AGE INT);", new Object[0]);
            RecordView view = client.tables().table("PERSON").recordView();
            CQexample.runCQ((RecordView<Tuple>)view);
            CQexample.runDedicatedExecutorCQ((RecordView<Tuple>)view);
        }
    }

    private static void runCQ(RecordView<Tuple> view) throws InterruptedException {
        SubscriberExample subscriber = new SubscriberExample();
        int pageSize = 1000;
        ContinuousQueryOptions options = ContinuousQueryOptions.builder().pollIntervalMs(10).pageSize(pageSize).skipOldEntries(false).build();
        view.queryContinuously((Flow.Subscriber)subscriber, options);
        view.upsert(null, (Object)Tuple.create().set("id", (Object)3).set("name", (Object)"John Doe"));
        view.upsert(null, (Object)Tuple.create().set("id", (Object)3).set("name", (Object)"Jane Doe"));
        view.delete(null, (Object)Tuple.create().set("id", (Object)3));
        Thread.sleep(3000L);
    }

    private static void runDedicatedExecutorCQ(RecordView<Tuple> view) throws InterruptedException {
        SubscriberExample subscriber = new SubscriberExample();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ContinuousQueryOptions options = ContinuousQueryOptions.builder().executor((Executor)executor).build();
        view.queryContinuously((Flow.Subscriber)subscriber, options);
        view.upsert(null, (Object)Tuple.create().set("id", (Object)5).set("name", (Object)"Jil Doe"));
        view.upsert(null, (Object)Tuple.create().set("id", (Object)5).set("name", (Object)"Jim Doe"));
        view.delete(null, (Object)Tuple.create().set("id", (Object)5));
        Thread.sleep(3000L);
        subscriber.cancel();
        executor.shutdownNow();
    }
}

