/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.compute;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.compute.JobDescriptor;
import org.apache.ignite.compute.JobExecutionOptions;
import org.apache.ignite.compute.JobExecutorType;
import org.apache.ignite.compute.JobTarget;
import org.apache.ignite.deployment.DeploymentUnit;

public class ComputeWasmJobExample {
    private static final DeploymentUnit DEPLOYMENT_UNIT = new DeploymentUnit("unit-wasm", "1.0.0");
    private static final String HELLO_FUNC = "test-module.wasm:addOne:int32";
    private static final JobExecutionOptions JOB_EXECUTION_OPTIONS = JobExecutionOptions.builder().executorType(JobExecutorType.WASM_EMBEDDED).build();

    public static void main(String[] args) throws ExecutionException, InterruptedException {
        System.out.println("\nConnecting to server...");
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            IgniteCompute compute = client.compute();
            JobDescriptor helloDesc = JobDescriptor.builder((String)HELLO_FUNC).units(new DeploymentUnit[]{DEPLOYMENT_UNIT}).options(JOB_EXECUTION_OPTIONS).build();
            JobTarget target = JobTarget.anyNode((Collection)client.cluster().nodes());
            Integer helloRes = (Integer)compute.execute(target, helloDesc, (Object)42);
            System.out.println("WASM job result: " + helloRes);
        }
    }
}

