/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.compute;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobDescriptor;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.compute.JobStatus;
import org.apache.ignite.compute.JobTarget;

public class ComputeJobStateExample {
    public static void main(String[] args) throws ExecutionException, InterruptedException {
        System.out.println("\nConnecting to server...");
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            System.out.println("\nConfiguring compute job...");
            CompletableFuture execution = client.compute().submitAsync(JobTarget.anyNode((Collection)client.cluster().nodes()), JobDescriptor.builder(WordPrintJob.class).build(), null);
            ((JobExecution)execution.get()).stateAsync().thenApply(state -> {
                if (state.status() == JobStatus.FAILED) {
                    System.out.println("\nJob failed...");
                }
                return null;
            });
        }
    }

    private static class WordPrintJob
    implements ComputeJob<String, Void> {
        private WordPrintJob() {
        }

        public CompletableFuture<Void> executeAsync(JobExecutionContext context, String arg) {
            System.out.println("\nProcessing word '" + arg + "' at node '" + context.ignite().name() + "'.");
            return CompletableFuture.completedFuture(null);
        }
    }
}

