/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.code.deployment;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.Ignite;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobExecutionContext;

public class MyJob
implements ComputeJob<String, String> {
    public CompletableFuture<String> executeAsync(JobExecutionContext ctx, String arg) {
        CompletableFuture<CallSite> completableFuture;
        block24: {
            Ignite ignite = ctx.ignite();
            String resPath = "/org/apache/ignite/example/code/deployment/resources/script.sh";
            InputStream in = MyJob.class.getResourceAsStream("/org/apache/ignite/example/code/deployment/resources/script.sh");
            try {
                String out;
                if (in == null) {
                    throw new IllegalStateException("Resource not found: /org/apache/ignite/example/code/deployment/resources/script.sh");
                }
                byte[] script = in.readAllBytes();
                Process p = new ProcessBuilder("sh", "-s", "--", arg).redirectErrorStream(true).start();
                try (OutputStream os = p.getOutputStream();){
                    os.write(script);
                }
                try (InputStream procOut = p.getInputStream();){
                    out = new String(procOut.readAllBytes(), StandardCharsets.UTF_8).strip();
                }
                int exit = p.waitFor();
                if (exit != 0) {
                    throw new RuntimeException("Script exited with code " + exit + ":\n" + out);
                }
                String result = "Node: " + ignite.name() + "\nArg: " + arg + "\nScript output:\n" + out;
                completableFuture = CompletableFuture.completedFuture(result);
                if (in == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to run script", e);
                }
            }
            in.close();
        }
        return completableFuture;
    }
}

