/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.code.deployment;

import java.util.Collection;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.compute.JobDescriptor;
import org.apache.ignite.compute.JobTarget;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.example.code.deployment.MyJob;

public class CodeDeploymentExample {
    private static final String DEPLOYMENT_UNIT_NAME = "codeDeploymentExampleUnit";
    private static final String DEPLOYMENT_UNIT_VERSION = "1.0.0";

    public static void main(String[] args) {
        System.out.println("\nConnecting to server...");
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            System.out.println("\nConfiguring compute job...");
            JobDescriptor job = JobDescriptor.builder(MyJob.class).units(new DeploymentUnit[]{new DeploymentUnit(DEPLOYMENT_UNIT_NAME, DEPLOYMENT_UNIT_VERSION)}).resultClass(String.class).build();
            JobTarget target = JobTarget.anyNode((Collection)client.cluster().nodes());
            System.out.println("\nExecuting compute job''...");
            String result = (String)client.compute().execute(target, job, (Object)"Hello from job");
            System.out.println("\n=== Result ===\n" + result);
        }
    }
}

