/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.cache;

import javax.sql.DataSource;
import org.apache.ignite.cache.CacheStoreFactory;
import org.apache.ignite.catalog.ColumnType;
import org.apache.ignite.catalog.definitions.CacheDefinition;
import org.apache.ignite.catalog.definitions.ColumnDefinition;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.example.cache.AccountKey;
import org.apache.ignite.example.cache.AccountValue;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionOptions;
import org.gridgain.cache.store.jdbc.JdbcCacheStoreFactory;
import org.gridgain.cache.store.jdbc.JdbcType;
import org.gridgain.cache.store.jdbc.JdbcTypeField;
import org.gridgain.cache.store.jdbc.dialect.H2Dialect;
import org.gridgain.cache.store.jdbc.dialect.JdbcDialect;
import org.h2.jdbcx.JdbcConnectionPool;

public class CacheExample {
    public static void main(String[] args) throws Exception {
        try (IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build();){
            JdbcConnectionPool dataSrc = JdbcConnectionPool.create((String)"jdbc:h2:mem:CacheExample", (String)"sa", (String)"");
            JdbcCacheStoreFactory storeFactory = new JdbcCacheStoreFactory();
            storeFactory.setDialect((JdbcDialect)new H2Dialect());
            JdbcType jdbcType = CacheExample.getJdbcTypeMapping();
            storeFactory.setType(jdbcType);
            storeFactory.setDataSource((DataSource)dataSrc);
            client.sql().execute("CREATE ZONE MYZONE WITH STORAGE_PROFILES='default'", new Object[0]);
            client.sql().execute("CREATE CACHE Accounts (accountNumber INT PRIMARY KEY,firstName VARCHAR,lastName VARCHAR,balance DOUBLE) ZONE MYZONE", new Object[0]);
            KeyValueView kvView = client.caches().cache("Accounts").keyValueView((CacheStoreFactory)storeFactory, Mapper.of(AccountKey.class), Mapper.of(AccountValue.class));
            CacheExample.updateCache((KeyValueView<AccountKey, AccountValue>)kvView);
            CacheExample.runCacheOnlyTx(client, (KeyValueView<AccountKey, AccountValue>)kvView);
        }
    }

    private static void updateCache(KeyValueView<AccountKey, AccountValue> kvView) {
        AccountKey key2 = new AccountKey(1234);
        AccountValue val2 = new AccountValue("John", "Smith", 100.0);
        kvView.put(null, (Object)key2, (Object)val2);
        System.out.printf("Read entry from Cache: %s%n", kvView.get(null, (Object)key2));
    }

    private static void updateTupleCache(KeyValueView<Tuple, Tuple> kvView) {
        Tuple key2 = Tuple.create().set("id", (Object)1234);
        Tuple val2 = Tuple.create().set("firstName", (Object)"John").set("lastName", (Object)"Smith").set("balance", (Object)100.0);
        kvView.put(null, (Object)key2, (Object)val2);
        System.out.printf("Read entry from Cache: %s%n", kvView.get(null, (Object)key2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runCacheOnlyTx(IgniteClient client, KeyValueView<AccountKey, AccountValue> kvView) {
        AccountKey k2;
        block3: {
            k2 = new AccountKey(2);
            AccountValue a2 = new AccountValue("Bob", "Smith", 750.0);
            Transaction tx = client.transactions().begin(new TransactionOptions().cacheOnly(true).timeoutMillis(5L));
            boolean committed = false;
            try {
                kvView.put(tx, (Object)k2, (Object)a2);
                committed = true;
                if (committed) break block3;
            }
            catch (Throwable throwable) {
                if (!committed) {
                    tx.rollback();
                }
                System.out.printf("Bob:   %s%n", kvView.get(null, (Object)k2));
                throw throwable;
            }
            tx.rollback();
        }
        System.out.printf("Bob:   %s%n", kvView.get(null, (Object)k2));
    }

    private static JdbcType getJdbcTypeMapping() {
        JdbcType jdbcType = new JdbcType();
        jdbcType.setDatabaseSchema("PUBLIC");
        jdbcType.setDatabaseTable("Accounts");
        jdbcType.setKeyType(AccountKey.class);
        jdbcType.setKeyFields(new JdbcTypeField[]{new JdbcTypeField(4, "accountNumber", Integer.class, "accountNumber")});
        jdbcType.setValueType(AccountValue.class);
        jdbcType.setValueFields(new JdbcTypeField[]{new JdbcTypeField(12, "firstName", String.class, "firstName"), new JdbcTypeField(12, "lastName", String.class, "lastName"), new JdbcTypeField(8, "balance", Double.class, "balance")});
        return jdbcType;
    }

    private static JdbcType getJdbcTypeMappingTuple() {
        JdbcType jdbcType = new JdbcType();
        jdbcType.setDatabaseSchema("PUBLIC");
        jdbcType.setDatabaseTable("Accounts");
        jdbcType.setKeyType(Tuple.class);
        jdbcType.setKeyFields(new JdbcTypeField[]{new JdbcTypeField(4, "id", Integer.class, "id"), new JdbcTypeField(12, "id_str", String.class, "idStr")});
        jdbcType.setValueType(Tuple.class);
        jdbcType.setValueFields(new JdbcTypeField[]{new JdbcTypeField(12, "firstName", String.class, "firstName"), new JdbcTypeField(12, "lastName", String.class, "lastName"), new JdbcTypeField(8, "balance", Double.class, "balance")});
        return jdbcType;
    }

    private void createCacheBuilder(IgniteClient client) {
        client.catalog().createCache(CacheDefinition.builder((String)"test").primaryKey(new String[]{"key"}).columns(new ColumnDefinition[]{ColumnDefinition.column((String)"key", (ColumnType)ColumnType.INT32), ColumnDefinition.column((String)"value", (ColumnType)ColumnType.INT32)}).build());
    }

    private KeyValueView<Tuple, Tuple> createViewTuple(IgniteClient client, JdbcCacheStoreFactory storeFactory) {
        return client.caches().cache("Accounts").keyValueView((CacheStoreFactory)storeFactory);
    }

    private void runCacheAsync(JdbcCacheStoreFactory storeFactory, AccountKey key, AccountValue value) {
        IgniteClient client = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).cache(ClientCacheConfiguration.builder().cacheWriteBehindParallelOperations(2048).build()).build();
        KeyValueView kvView = client.caches().cache("Accounts").keyValueView((CacheStoreFactory)storeFactory, Mapper.of(AccountKey.class), Mapper.of(AccountValue.class));
        kvView.put(null, (Object)key, (Object)value);
    }
}

