/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.cache;

import org.apache.ignite.cache.CacheStoreFactory;
import org.apache.ignite.catalog.SortOrder;
import org.apache.ignite.catalog.annotations.Cache;
import org.apache.ignite.catalog.annotations.Column;
import org.apache.ignite.catalog.annotations.ColumnRef;
import org.apache.ignite.catalog.annotations.Id;
import org.apache.ignite.catalog.annotations.Index;
import org.apache.ignite.catalog.annotations.Zone;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.table.mapper.Mapper;
import org.gridgain.cache.store.jdbc.JdbcCacheStoreFactory;
import org.gridgain.cache.store.jdbc.dialect.H2Dialect;
import org.gridgain.cache.store.jdbc.dialect.JdbcDialect;

@Cache(value="kv-pojo", zone=@Zone(value="my_zone", replicas=2, storageProfiles="default"), colocateBy={@ColumnRef(value="id"), @ColumnRef(value="id_str")}, indexes={@Index(value="ix", columns={@ColumnRef(value="f_name"), @ColumnRef(value="l_name")})})
class AccountPojo {
    AccountPojo() {
    }

    public void createCache() {
        org.apache.ignite.cache.Cache myCache = IgniteClient.builder().addresses(new String[]{"127.0.0.1:10800"}).build().catalog().createCache(AccountPojoKey.class, AccountPojoValue.class);
        myCache.keyValueView((CacheStoreFactory)new JdbcCacheStoreFactory().setDialect((JdbcDialect)new H2Dialect()), Mapper.of(AccountPojoKey.class), Mapper.of(AccountPojoValue.class));
    }

    class AccountPojoKey {
        @Id
        Integer id;
        @Id(value=SortOrder.DESC)
        @Column(value="id_str", length=20)
        String idStr;

        AccountPojoKey() {
        }
    }

    class AccountPojoValue {
        @Column(value="f_name")
        String firstName;
        @Column(value="l_name")
        String lastName;
        String str;

        AccountPojoValue() {
        }
    }
}

