/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.ml.custom;

import ai.djl.Model;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.example.ml.custom.CustomInput;
import org.apache.ignite.example.ml.custom.CustomOutput;
import org.apache.ignite.example.ml.custom.CustomTranslator;

public class CustomTranslatorFactory
implements TranslatorFactory,
Serializable {
    private static final long serialVersionUID = 1L;

    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) throws TranslateException {
        Path modelPath = model.getModelPath();
        try {
            HuggingFaceTokenizer tokenizer = HuggingFaceTokenizer.builder(arguments).optTokenizerPath(modelPath).optManager(model.getNDManager()).build();
            CustomTranslator translator = CustomTranslator.builder(tokenizer, arguments).build();
            return translator;
        }
        catch (IOException var8) {
            throw new TranslateException("Failed to load tokenizer.", (Throwable)var8);
        }
    }

    public Set<Pair<Type, Type>> getSupportedTypes() {
        return Set.of(new Pair(Object.class, Object.class), new Pair(CustomInput.class, CustomOutput.class));
    }
}

