/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.example.ml.custom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.ignite.marshalling.ByteArrayMarshaller;
import org.apache.ignite.marshalling.MarshallingException;
import org.apache.ignite.marshalling.UnmarshallingException;

public class CustomOutputListMarshaller<O>
implements ByteArrayMarshaller<List<O>>,
Serializable {
    private static final long serialVersionUID = -4079032386152752293L;

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] marshal(List<O> obj) throws MarshallingException {
        if (obj != null) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    oos.writeObject(obj);
                    oos.flush();
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new MarshallingException("Failed to marshal Output", (Throwable)e);
            }
        }
        return new byte[0];
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<O> unmarshal(byte[] data) throws UnmarshallingException {
        if (data != null) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
                List list;
                try (ObjectInputStream ois = new ObjectInputStream(bais);){
                    list = (List)ois.readObject();
                }
                return list;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new UnmarshallingException("Failed to unmarshal Output", (Throwable)e);
            }
        }
        return null;
    }
}

