/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.eventlog.impl;

import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ignite.internal.eventlog.api.Sink;
import org.apache.ignite.internal.eventlog.config.schema.LogSinkView;
import org.apache.ignite.internal.eventlog.config.schema.SinkView;
import org.apache.ignite.internal.eventlog.config.schema.WebhookSinkView;
import org.apache.ignite.internal.eventlog.impl.LogSink;
import org.apache.ignite.internal.eventlog.impl.SinkFactory;
import org.apache.ignite.internal.eventlog.impl.WebhookSink;
import org.apache.ignite.internal.eventlog.ser.EventSerializer;

public class SinkFactoryImpl
implements SinkFactory {
    private final EventSerializer eventSerializer;
    private final Supplier<UUID> clusterIdSupplier;
    private final String nodeName;

    SinkFactoryImpl(EventSerializer eventSerializer, Supplier<UUID> clusterIdSupplier, String nodeName) {
        this.eventSerializer = eventSerializer;
        this.clusterIdSupplier = clusterIdSupplier;
        this.nodeName = nodeName;
    }

    @Override
    public Sink createSink(SinkView sinkView) {
        if (sinkView instanceof LogSinkView) {
            return new LogSink((LogSinkView)sinkView, this.eventSerializer);
        }
        if (sinkView instanceof WebhookSinkView) {
            return new WebhookSink((WebhookSinkView)sinkView, this.eventSerializer, this.clusterIdSupplier, this.nodeName);
        }
        return SinkFactory.super.createSink(sinkView);
    }
}

