/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.exception;

import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class DistributionZoneNotFoundException
extends IgniteInternalException {
    private static final long serialVersionUID = 4690347752201656106L;

    public DistributionZoneNotFoundException(int zoneId) {
        super(ErrorGroups.DistributionZones.ZONE_NOT_FOUND_ERR, "Distribution zone was not found [zoneId=" + zoneId + "]");
    }

    public DistributionZoneNotFoundException(String zoneName) {
        super(ErrorGroups.DistributionZones.ZONE_NOT_FOUND_ERR, "Distribution zone was not found [zoneName=" + zoneName + "]");
    }

    public DistributionZoneNotFoundException(Collection<String> zoneNames) {
        super(ErrorGroups.DistributionZones.ZONE_NOT_FOUND_ERR, "Distribution zones were not found [zoneNames=" + zoneNames + "]");
    }

    public DistributionZoneNotFoundException(String zoneName, @Nullable Throwable cause) {
        super(ErrorGroups.DistributionZones.ZONE_NOT_FOUND_ERR, "Distribution zone was not found [zoneName=" + zoneName + "]", cause);
    }

    public DistributionZoneNotFoundException(UUID traceId, int code, String message, Throwable cause) {
        super(traceId, code, message, cause);
    }
}

