/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones;

import java.util.List;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.distributionzones.rebalance.ZoneRebalanceUtil;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.IntGauge;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.jetbrains.annotations.Nullable;

public class ZoneMetricSource
extends AbstractMetricSource<Holder> {
    public static final String SOURCE_NAME = "zones";
    public static final String LOCAL_UNREBALANCED_PARTITIONS_COUNT = "LocalUnrebalancedPartitionsCount";
    public static final String TOTAL_UNREBALANCED_PARTITIONS_COUNT = "TotalUnrebalancedPartitionsCount";
    private final MetaStorageManager metaStorageManager;
    private final String nodeName;
    private final int zoneId;
    private final int partitions;
    private final String zoneName;

    public ZoneMetricSource(MetaStorageManager metaStorageManager, String consistentId, CatalogZoneDescriptor zoneDescriptor) {
        super(ZoneMetricSource.sourceName(zoneDescriptor.name()), "Distribution zone metrics.", SOURCE_NAME);
        this.nodeName = consistentId;
        this.metaStorageManager = metaStorageManager;
        this.zoneId = zoneDescriptor.id();
        this.partitions = zoneDescriptor.partitions();
        this.zoneName = zoneDescriptor.name();
    }

    public ZoneMetricSource(MetaStorageManager metaStorageManager, String consistentId, CatalogZoneDescriptor zoneDescriptor, ZoneMetricSource source) {
        super(ZoneMetricSource.sourceName(zoneDescriptor.name()), "Distribution zone metrics.", SOURCE_NAME, (AbstractMetricSource.Holder)Holder.copyFrom(source));
        assert (zoneDescriptor.id() == source.zoneId) : "Zone ID mismatch [expected=" + zoneDescriptor.id() + ", actual=" + source.zoneId + "]";
        assert (zoneDescriptor.partitions() == source.partitions) : "Partitions count mismatch [expected=" + zoneDescriptor.partitions() + ", actual=" + source.partitions + "]";
        this.nodeName = consistentId;
        this.metaStorageManager = metaStorageManager;
        this.zoneId = zoneDescriptor.id();
        this.partitions = zoneDescriptor.partitions();
        this.zoneName = zoneDescriptor.name();
    }

    public static String sourceName(String zoneName) {
        return "zones." + zoneName;
    }

    protected Holder createHolder() {
        return new Holder(this.zoneId, this.partitions, this.metaStorageManager, this.nodeName);
    }

    public String zoneName() {
        return this.zoneName;
    }

    protected static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final List<Metric> metrics;

        @Nullable
        static Holder copyFrom(ZoneMetricSource source) {
            return (Holder)source.holder();
        }

        Holder(int zoneId, int partitions, MetaStorageManager metaStorageManager, String nodeName) {
            IntGauge localUnrebalancedPartitionsCount = new IntGauge(ZoneMetricSource.LOCAL_UNREBALANCED_PARTITIONS_COUNT, "The number of partitions that should be moved to this node.", () -> {
                int unrebalancedParts = 0;
                for (int i = 0; i < partitions; ++i) {
                    ZonePartitionId zonePartitionId = new ZonePartitionId(zoneId, i);
                    Entry pendingEntry = metaStorageManager.getLocally(ZoneRebalanceUtil.pendingPartAssignmentsQueueKey(zonePartitionId));
                    AssignmentsQueue pendingAssignmentsQueue = AssignmentsQueue.fromBytes((byte[])pendingEntry.value());
                    if (pendingAssignmentsQueue == null) continue;
                    Entry stableEntry = metaStorageManager.getLocally(ZoneRebalanceUtil.stablePartAssignmentsKey(zonePartitionId));
                    Assignments stableAssignments = stableEntry.value() == null ? Assignments.EMPTY : Assignments.fromBytes((byte[])stableEntry.value());
                    Assignments targetAssignments = pendingAssignmentsQueue.peekLast();
                    boolean stable = Holder.presentInAssignments(stableAssignments, nodeName);
                    boolean pending = Holder.presentInAssignments(targetAssignments, nodeName);
                    if (stable || !pending) continue;
                    ++unrebalancedParts;
                }
                return unrebalancedParts;
            });
            IntGauge totalUnrebalancedPartitionsCount = new IntGauge(ZoneMetricSource.TOTAL_UNREBALANCED_PARTITIONS_COUNT, "The total number of partitions that should be moved to a new owner.", () -> {
                int unrebalancedParts = 0;
                for (int i = 0; i < partitions; ++i) {
                    ZonePartitionId zonePartitionId = new ZonePartitionId(zoneId, i);
                    Entry pendingEntry = metaStorageManager.getLocally(ZoneRebalanceUtil.pendingPartAssignmentsQueueKey(zonePartitionId));
                    AssignmentsQueue pendingAssignmentsQueue = AssignmentsQueue.fromBytes((byte[])pendingEntry.value());
                    if (pendingAssignmentsQueue == null) continue;
                    Entry stableEntry = metaStorageManager.getLocally(ZoneRebalanceUtil.stablePartAssignmentsKey(zonePartitionId));
                    Assignments stableAssignments = stableEntry.value() == null ? Assignments.EMPTY : Assignments.fromBytes((byte[])stableEntry.value());
                    Assignments targetAssignments = pendingAssignmentsQueue.peekLast();
                    for (Assignment pendingAssignment : targetAssignments.nodes()) {
                        if (Holder.presentInAssignments(stableAssignments, pendingAssignment.consistentId())) continue;
                        ++unrebalancedParts;
                    }
                }
                return unrebalancedParts;
            });
            this.metrics = List.of(localUnrebalancedPartitionsCount, totalUnrebalancedPartitionsCount);
        }

        public Iterable<Metric> metrics() {
            return this.metrics;
        }

        private static boolean presentInAssignments(Assignments assignments, String nodeName) {
            return assignments.nodes().stream().anyMatch(assignment -> assignment.consistentId().equals(nodeName));
        }
    }
}

