/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.rebalance;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.raft.service.RaftGroupService;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.lang.ErrorGroups;

public class PartitionMover {
    private static final IgniteLogger LOG = Loggers.forClass(PartitionMover.class);
    private static final long MOVE_RESCHEDULE_DELAY_MILLIS = 100L;
    private final IgniteSpinBusyLock busyLock;
    private final ScheduledExecutorService rebalanceScheduler;
    private final Supplier<CompletableFuture<RaftGroupService>> raftGroupServiceSupplier;

    public PartitionMover(IgniteSpinBusyLock busyLock, ScheduledExecutorService rebalanceScheduler, Supplier<CompletableFuture<RaftGroupService>> raftGroupServiceSupplier) {
        this.busyLock = busyLock;
        this.rebalanceScheduler = rebalanceScheduler;
        this.raftGroupServiceSupplier = raftGroupServiceSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> movePartition(PeersAndLearners peersAndLearners, long term, long sequenceToken) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)this.raftGroupServiceSupplier.get().thenCompose(raftGroupService -> raftGroupService.changePeersAndLearnersAsync(peersAndLearners, term, sequenceToken))).handle((resp, err) -> {
                if (!this.busyLock.enterBusy()) {
                    throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
                }
                try {
                    if (err != null) {
                        if (RebalanceUtil.recoverable(err)) {
                            LOG.debug("Recoverable error received during changePeersAndLearnersAsync invocation, retrying", err);
                        } else {
                            LOG.debug("Unrecoverable error received during changePeersAndLearnersAsync invocation, retrying", err);
                        }
                        CompletableFuture future = new CompletableFuture();
                        this.rebalanceScheduler.schedule(() -> this.movePartition(peersAndLearners, term, sequenceToken).whenComplete(CompletableFutures.copyStateTo((CompletableFuture)future)), 100L, TimeUnit.MILLISECONDS);
                        CompletableFuture completableFuture = future;
                        return completableFuture;
                    }
                    CompletableFuture completableFuture = CompletableFutures.nullCompletedFuture();
                    return completableFuture;
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            })).thenCompose(Function.identity());
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }
}

