/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.commands.StorageProfileParams;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfileDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.distributionzones.DataNodesHistory;
import org.apache.ignite.internal.distributionzones.DistributionZoneTimer;
import org.apache.ignite.internal.distributionzones.LogicalTopologySetSerializer;
import org.apache.ignite.internal.distributionzones.Node;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.NodesAttributesSerializer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.dsl.CompoundCondition;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.Update;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.StripedScheduledThreadPoolExecutor;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DistributionZonesUtil {
    private static final String DISTRIBUTION_ZONE_PREFIX = "distributionZone.";
    private static final String DISTRIBUTION_ZONE_DATA_NODES_PREFIX = "distributionZone.dataNodes.";
    public static final String DISTRIBUTION_ZONE_DATA_NODES_HISTORY_PREFIX = "distributionZone.dataNodes.history.";
    @Deprecated
    public static final String DISTRIBUTION_ZONE_DATA_NODES_VALUE_PREFIX = "distributionZone.dataNodes.value.";
    public static final byte[] DISTRIBUTION_ZONE_DATA_NODES_HISTORY_PREFIX_BYTES = "distributionZone.dataNodes.history.".getBytes(StandardCharsets.UTF_8);
    public static final String DISTRIBUTION_ZONE_SCALE_UP_TIMER_PREFIX = "distributionZone.dataNodes.scaleUpTimer.";
    static final byte[] DISTRIBUTION_ZONE_SCALE_UP_TIMER_PREFIX_BYTES = "distributionZone.dataNodes.scaleUpTimer.".getBytes(StandardCharsets.UTF_8);
    public static final String DISTRIBUTION_ZONE_SCALE_DOWN_TIMER_PREFIX = "distributionZone.dataNodes.scaleDownTimer.";
    static final byte[] DISTRIBUTION_ZONE_SCALE_DOWN_TIMER_PREFIX_BYTES = "distributionZone.dataNodes.scaleDownTimer.".getBytes(StandardCharsets.UTF_8);
    private static final String DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_PREFIX = "distributionZones.logicalTopology.";
    private static final String DISTRIBUTION_ZONES_NODES_ATTRIBUTES = "distributionZones.nodesAttributes";
    private static final String DISTRIBUTION_ZONES_RECOVERABLE_STATE_REVISION = "distributionZones.recoverableStateRevision";
    private static final String DISTRIBUTION_ZONES_LAST_HANDLED_TOPOLOGY = "distributionZones.lastHandledTopology";
    private static final String DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY = "distributionZones.logicalTopology.nodes";
    private static final String DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_VERSION = "distributionZones.logicalTopology.version";
    private static final String DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_CLUSTER_ID = "distributionZones.logicalTopology.clusterId";
    private static final ByteArray DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_KEY = new ByteArray("distributionZones.logicalTopology.nodes");
    @Deprecated
    private static final ByteArray DISTRIBUTION_ZONES_NODES_ATTRIBUTES_KEY = new ByteArray("distributionZones.nodesAttributes");
    private static final ByteArray DISTRIBUTION_ZONES_RECOVERABLE_STATE_REVISION_KEY = new ByteArray("distributionZones.recoverableStateRevision");
    private static final ByteArray DISTRIBUTION_ZONES_LAST_HANDLED_TOPOLOGY_KEY = new ByteArray("distributionZones.lastHandledTopology");
    private static final ByteArray DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_VERSION_KEY = new ByteArray("distributionZones.logicalTopology.version");
    private static final ByteArray DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_CLUSTER_ID_KEY = new ByteArray("distributionZones.logicalTopology.clusterId");
    public static final String PARTITION_DISTRIBUTION_RESET_TIMEOUT = "partitionDistributionResetTimeout";
    static final int PARTITION_DISTRIBUTION_RESET_TIMEOUT_DEFAULT_VALUE = 0;
    public static final String REBALANCE_RETRY_DELAY_MS = "rebalanceRetryDelay";
    public static final int REBALANCE_RETRY_DELAY_DEFAULT = 200;

    public static ByteArray zoneDataNodesHistoryPrefix() {
        return new ByteArray(DISTRIBUTION_ZONE_DATA_NODES_HISTORY_PREFIX);
    }

    @Deprecated
    public static ByteArray zoneDataNodesKey(int zoneId) {
        return new ByteArray(DISTRIBUTION_ZONE_DATA_NODES_VALUE_PREFIX + zoneId);
    }

    public static ByteArray zoneDataNodesHistoryKey(int zoneId) {
        return new ByteArray(DISTRIBUTION_ZONE_DATA_NODES_HISTORY_PREFIX + zoneId);
    }

    public static ByteArray zoneScaleUpTimerPrefix() {
        return new ByteArray(DISTRIBUTION_ZONE_SCALE_UP_TIMER_PREFIX);
    }

    public static ByteArray zoneScaleUpTimerKey(int zoneId) {
        return new ByteArray(DISTRIBUTION_ZONE_SCALE_UP_TIMER_PREFIX + zoneId);
    }

    public static ByteArray zoneScaleDownTimerPrefix() {
        return new ByteArray(DISTRIBUTION_ZONE_SCALE_DOWN_TIMER_PREFIX);
    }

    public static ByteArray zoneScaleDownTimerKey(int zoneId) {
        return new ByteArray(DISTRIBUTION_ZONE_SCALE_DOWN_TIMER_PREFIX + zoneId);
    }

    public static ByteArray zonesLogicalTopologyPrefix() {
        return new ByteArray(DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_PREFIX);
    }

    public static ByteArray zonesLogicalTopologyKey() {
        return DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_KEY;
    }

    public static ByteArray zonesLogicalTopologyVersionKey() {
        return DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_VERSION_KEY;
    }

    public static ByteArray zonesLogicalTopologyClusterIdKey() {
        return DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_CLUSTER_ID_KEY;
    }

    @Deprecated
    public static ByteArray zonesNodesAttributes() {
        return DISTRIBUTION_ZONES_NODES_ATTRIBUTES_KEY;
    }

    public static ByteArray zonesRecoverableStateRevision() {
        return DISTRIBUTION_ZONES_RECOVERABLE_STATE_REVISION_KEY;
    }

    public static ByteArray zonesLastHandledTopology() {
        return DISTRIBUTION_ZONES_LAST_HANDLED_TOPOLOGY_KEY;
    }

    static CompoundCondition conditionForRecoverableStateChanges(long revision) {
        return Conditions.or((Condition)Conditions.notExists((ByteArray)DistributionZonesUtil.zonesRecoverableStateRevision()), (Condition)Conditions.value((ByteArray)DistributionZonesUtil.zonesRecoverableStateRevision()).lt(ByteUtils.longToBytesKeepingOrder((long)revision)));
    }

    static Update updateLogicalTopologyAndVersion(LogicalTopologySnapshot logicalTopology) {
        return DistributionZonesUtil.updateLogicalTopologyAndVersionAndMaybeClusterId(logicalTopology, false);
    }

    static Update updateLogicalTopologyAndVersionAndClusterId(LogicalTopologySnapshot logicalTopology) {
        return DistributionZonesUtil.updateLogicalTopologyAndVersionAndMaybeClusterId(logicalTopology, true);
    }

    private static Update updateLogicalTopologyAndVersionAndMaybeClusterId(LogicalTopologySnapshot logicalTopology, boolean updateClusterId) {
        Set<NodeWithAttributes> topologyFromCmg = logicalTopology.nodes().stream().map(n -> new NodeWithAttributes(n.name(), n.id(), n.userAttributes(), n.storageProfiles())).collect(Collectors.toSet());
        ArrayList<Operation> operations = new ArrayList<Operation>();
        operations.add(Operations.put((ByteArray)DistributionZonesUtil.zonesLogicalTopologyVersionKey(), (byte[])ByteUtils.longToBytesKeepingOrder((long)logicalTopology.version())));
        operations.add(Operations.put((ByteArray)DistributionZonesUtil.zonesLogicalTopologyKey(), (byte[])LogicalTopologySetSerializer.serialize(topologyFromCmg)));
        if (updateClusterId) {
            operations.add(Operations.put((ByteArray)DistributionZonesUtil.zonesLogicalTopologyClusterIdKey(), (byte[])ByteUtils.uuidToBytes((UUID)logicalTopology.clusterId())));
        }
        return Operations.ops((Operation[])((Operation[])operations.toArray(Operation[]::new))).yield(true);
    }

    public static Set<Node> dataNodes(Map<Node, Integer> dataNodesMap) {
        return dataNodesMap.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static Set<Node> dataNodes(Set<NodeWithAttributes> dataNodes) {
        return dataNodes.stream().map(NodeWithAttributes::node).collect(Collectors.toSet());
    }

    @Nullable
    public static Set<NodeWithAttributes> parseDataNodes(byte[] dataNodesBytes, HybridTimestamp timestamp) {
        if (dataNodesBytes == null) {
            return null;
        }
        DataNodesHistory dataNodesHistory = DataNodesHistory.DataNodesHistorySerializer.deserialize(dataNodesBytes);
        return dataNodesHistory.dataNodesForTimestamp(timestamp).dataNodes();
    }

    public static Set<NodeWithAttributes> deserializeLogicalTopologySet(byte[] bytes) {
        return LogicalTopologySetSerializer.deserialize(bytes);
    }

    static Map<UUID, NodeWithAttributes> deserializeNodesAttributes(byte[] bytes) {
        return NodesAttributesSerializer.deserialize(bytes);
    }

    @Nullable
    public static DataNodesHistoryContext dataNodeHistoryContextFromValues(Collection<Entry> entries) {
        DataNodesHistory dataNodesHistory = null;
        DistributionZoneTimer scaleUpTimer = null;
        DistributionZoneTimer scaleDownTimer = null;
        for (Entry e : entries) {
            byte[] v;
            if (e.empty()) {
                return null;
            }
            assert (e != null && e.key() != null) : "Unexpected entry: " + e;
            byte[] byArray = v = e.tombstone() ? null : e.value();
            if (IgniteUtils.startsWith((byte[])e.key(), (byte[])DISTRIBUTION_ZONE_DATA_NODES_HISTORY_PREFIX_BYTES)) {
                dataNodesHistory = v == null ? null : DataNodesHistory.DataNodesHistorySerializer.deserialize(v);
                continue;
            }
            if (IgniteUtils.startsWith((byte[])e.key(), (byte[])DISTRIBUTION_ZONE_SCALE_UP_TIMER_PREFIX_BYTES)) {
                scaleUpTimer = v == null ? null : DistributionZoneTimer.DistributionZoneTimerSerializer.deserialize(v);
                continue;
            }
            if (!IgniteUtils.startsWith((byte[])e.key(), (byte[])DISTRIBUTION_ZONE_SCALE_DOWN_TIMER_PREFIX_BYTES)) continue;
            scaleDownTimer = v == null ? null : DistributionZoneTimer.DistributionZoneTimerSerializer.deserialize(v);
        }
        return new DataNodesHistoryContext(dataNodesHistory, scaleUpTimer, scaleDownTimer);
    }

    public static boolean filterNodeAttributes(Map<String, String> nodeAttributes, String filter) {
        if (filter.equals("$..*")) {
            return true;
        }
        Map<String, Object> convertedAttributes = nodeAttributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            long res;
            try {
                res = Long.parseLong((String)e.getValue());
            }
            catch (NumberFormatException ignored) {
                return e.getValue();
            }
            return res;
        }));
        Configuration jsonPathCfg = new Configuration.ConfigurationBuilder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST}).build();
        List res = (List)JsonPath.using((Configuration)jsonPathCfg).parse(convertedAttributes).read(filter, new Predicate[0]);
        return !res.isEmpty();
    }

    public static boolean filterStorageProfiles(NodeWithAttributes node, List<String> zoneStorageProfiles) {
        if (node.storageProfiles() == null) {
            return false;
        }
        return new HashSet<String>(node.storageProfiles()).containsAll(zoneStorageProfiles);
    }

    public static Set<NodeWithAttributes> filterDataNodes(Set<NodeWithAttributes> dataNodes, CatalogZoneDescriptor zoneDescriptor) {
        List<String> storageProfiles = zoneDescriptor.storageProfiles().profiles().stream().map(CatalogStorageProfileDescriptor::storageProfile).collect(Collectors.toList());
        return DistributionZonesUtil.filterDataNodes(dataNodes, zoneDescriptor.filter(), storageProfiles);
    }

    public static Set<NodeWithAttributes> filterDataNodes(Set<NodeWithAttributes> dataNodes, String filter, List<String> storageProfiles) {
        return dataNodes.stream().filter(n -> DistributionZonesUtil.filterNodeAttributes(n.userAttributes(), filter)).filter(n -> DistributionZonesUtil.filterStorageProfiles(n, storageProfiles)).collect(Collectors.toSet());
    }

    public static List<StorageProfileParams> parseStorageProfiles(String storageProfiles) {
        List<String> items = Arrays.asList(storageProfiles.split("\\s*,\\s*"));
        return items.stream().map(p -> StorageProfileParams.builder().storageProfile(p).build()).collect(Collectors.toList());
    }

    static StripedScheduledThreadPoolExecutor createZoneManagerExecutor(int concurrencyLvl, IgniteThreadFactory threadFactory) {
        return new StripedScheduledThreadPoolExecutor(concurrencyLvl, (ThreadFactory)threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
    }

    public static Set<String> nodeNames(Set<NodeWithAttributes> nodes) {
        return nodes.stream().map(NodeWithAttributes::nodeName).collect(Collectors.toSet());
    }

    public static class DataNodesHistoryContext {
        @Nullable
        private final DataNodesHistory dataNodesHistory;
        @Nullable
        private final DistributionZoneTimer scaleUpTimer;
        @Nullable
        private final DistributionZoneTimer scaleDownTimer;

        DataNodesHistoryContext(@Nullable DataNodesHistory dataNodesHistory, @Nullable DistributionZoneTimer scaleUpTimer, @Nullable DistributionZoneTimer scaleDownTimer) {
            this.dataNodesHistory = dataNodesHistory;
            this.scaleUpTimer = scaleUpTimer;
            this.scaleDownTimer = scaleDownTimer;
        }

        public DataNodesHistory dataNodesHistory() {
            assert (this.dataNodesHistory != null) : "Data nodes history were not initialized.";
            return this.dataNodesHistory;
        }

        public DistributionZoneTimer scaleUpTimer() {
            assert (this.scaleUpTimer != null) : "Scale up timer was not initialized.";
            return this.scaleUpTimer;
        }

        @TestOnly
        public boolean scaleUpTimerPresent() {
            return this.scaleUpTimer != null;
        }

        @TestOnly
        public boolean scaleDownTimerPresent() {
            return this.scaleDownTimer != null;
        }

        public DistributionZoneTimer scaleDownTimer() {
            assert (this.scaleDownTimer != null) : "Scale down timer was not initialized.";
            return this.scaleDownTimer;
        }
    }
}

