/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.rebalance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsQueue;

public class AssignmentUtil {
    public static int[] partitionIds(Set<Integer> partitionIds, int numberOfPartitions) {
        IntStream partitionIdsStream = partitionIds.isEmpty() ? IntStream.range(0, numberOfPartitions) : partitionIds.stream().mapToInt(Integer::intValue);
        return partitionIdsStream.toArray();
    }

    public static int[] partitionIds(int numberOfPartitions) {
        return AssignmentUtil.partitionIds(Set.of(), numberOfPartitions);
    }

    public static CompletableFuture<Map<Integer, Assignments>> metastoreAssignments(MetaStorageManager metaStorageManager, int[] partitionIds, Function<Integer, ByteArray> keyForPartition, Function<byte[], Assignments> deserializer) {
        HashMap<ByteArray, Integer> partitionKeysToPartitionNumber = new HashMap<ByteArray, Integer>();
        for (int partitionId : partitionIds) {
            partitionKeysToPartitionNumber.put(keyForPartition.apply(partitionId), partitionId);
        }
        return metaStorageManager.getAll(partitionKeysToPartitionNumber.keySet()).thenApply(entries -> {
            if (entries.isEmpty()) {
                return Map.of();
            }
            HashMap<Integer, Assignments> result = new HashMap<Integer, Assignments>();
            for (Map.Entry mapEntry : entries.entrySet()) {
                Entry entry = (Entry)mapEntry.getValue();
                if (entry.empty() || entry.tombstone()) continue;
                result.put((Integer)partitionKeysToPartitionNumber.get(mapEntry.getKey()), (Assignments)deserializer.apply(entry.value()));
            }
            return result.isEmpty() ? Map.of() : result;
        });
    }

    public static List<Set<Assignment>> assignmentsAsList(Map<Integer, Assignments> assignmentsMap, int partitions) {
        ArrayList<Set<Assignment>> allAssignments = new ArrayList<Set<Assignment>>(partitions);
        for (int i = 0; i < partitions; ++i) {
            Assignments partitionAssignment = assignmentsMap.get(i);
            Set nodes = partitionAssignment == null ? Collections.emptySet() : partitionAssignment.nodes();
            Set assignmentsWithoutSecondaryStorages = nodes.stream().filter(a -> !AssignmentUtil.isSecondaryStorageAssignment(a, nodes)).collect(Collectors.toSet());
            allAssignments.add(assignmentsWithoutSecondaryStorages);
        }
        return allAssignments;
    }

    private static boolean isSecondaryStorageAssignment(Assignment assignment, Set<Assignment> allAssignments) {
        return !assignment.isPeer() && allAssignments.contains(Assignment.forPeer((String)assignment.consistentId()));
    }

    public static List<Set<Assignment>> currentDistributionFromLocalMetaStorage(MetaStorageManager metaStorageMgr, int partitions, Function<Integer, ByteArray> partIdToStableAssignmentKey, Function<Integer, ByteArray> partIdToPendingAssignmentKey) {
        ArrayList<ByteArray> stableAssignmentKeys = new ArrayList<ByteArray>(partitions);
        ArrayList<ByteArray> pendingAssignmentKeys = new ArrayList<ByteArray>(partitions);
        for (int p = 0; p < partitions; ++p) {
            stableAssignmentKeys.add(partIdToStableAssignmentKey.apply(p));
            pendingAssignmentKeys.add(partIdToPendingAssignmentKey.apply(p));
        }
        HashSet<ByteArray> keys = new HashSet<ByteArray>(stableAssignmentKeys);
        keys.addAll(pendingAssignmentKeys);
        Map entries = metaStorageMgr.getAllLocally(keys);
        ArrayList<Set<Assignment>> result = new ArrayList<Set<Assignment>>();
        for (int p = 0; p < partitions; ++p) {
            Entry entry;
            Entry stableEntry = (Entry)entries.get(stableAssignmentKeys.get(p));
            Entry pendingEntry = (Entry)entries.get(pendingAssignmentKeys.get(p));
            boolean isStable = pendingEntry == null || pendingEntry.empty() || pendingEntry.tombstone();
            Entry entry2 = entry = isStable ? stableEntry : pendingEntry;
            assert (!entry.empty() && !entry.tombstone()) : IgniteStringFormatter.format((String)"Couldn't retrieve correct assignment entry [partition={}, pendingKey={}, pendingEntry={}, stableKey={}, stableEntry={}]", (Object[])new Object[]{p, ((ByteArray)pendingAssignmentKeys.get(p)).toString(), pendingEntry, ((ByteArray)stableAssignmentKeys.get(p)).toString(), stableEntry});
            Set assignments = isStable ? Assignments.fromBytes((byte[])entry.value()).nodes() : AssignmentsQueue.fromBytes((byte[])entry.value()).poll().nodes();
            result.add(assignments);
        }
        return result;
    }
}

