/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.distributionzones.DataNodesHistory;
import org.apache.ignite.internal.distributionzones.DistributionZoneTimer;
import org.apache.ignite.internal.distributionzones.DistributionZonesUtil;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Iif;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.Statements;
import org.apache.ignite.internal.metastorage.dsl.Update;
import org.jetbrains.annotations.Nullable;

class DataNodesHistoryMetaStorageOperation {
    private final Condition condition;
    private final List<Operation> operations;
    private final String operationName;
    private final int zoneId;
    private final DataNodesHistory currentDataNodesHistory;
    private final HybridTimestamp currentTimestamp;
    private final HybridTimestamp historyEntryTimestamp;
    private final Set<NodeWithAttributes> historyEntryNodes;
    private final boolean addMandatoryEntry;
    @Nullable
    private final DistributionZoneTimer scaleUpTimer;
    @Nullable
    private final DistributionZoneTimer scaleDownTimer;

    private DataNodesHistoryMetaStorageOperation(Condition condition, List<Operation> operations, String operationName, int zoneId, DataNodesHistory currentDataNodesHistory, HybridTimestamp currentTimestamp, HybridTimestamp historyEntryTimestamp, Set<NodeWithAttributes> historyEntryNodes, boolean addMandatoryEntry, @Nullable DistributionZoneTimer scaleUpTimer, @Nullable DistributionZoneTimer scaleDownTimer) {
        this.condition = condition;
        this.operations = operations;
        this.operationName = operationName;
        this.zoneId = zoneId;
        this.currentDataNodesHistory = currentDataNodesHistory;
        this.currentTimestamp = currentTimestamp;
        this.historyEntryTimestamp = historyEntryTimestamp;
        this.historyEntryNodes = historyEntryNodes;
        this.addMandatoryEntry = addMandatoryEntry;
        this.scaleUpTimer = scaleUpTimer;
        this.scaleDownTimer = scaleDownTimer;
    }

    static Builder builder() {
        return new Builder();
    }

    String successLogMessage() {
        Set<NodeWithAttributes> latestNodesWritten = this.currentDataNodesHistory.dataNodesForTimestamp(HybridTimestamp.MAX_VALUE).dataNodes();
        Set<NodeWithAttributes> nodes = this.historyEntryNodes;
        boolean historyEntryAdded = this.addMandatoryEntry || this.currentDataNodesHistory.isEmpty() || !nodes.equals(latestNodesWritten);
        return "Updated data nodes on " + this.operationName + ", " + (historyEntryAdded ? "added history entry" : "history entry not added") + " [zoneId=" + this.zoneId + ", currentTimestamp=" + this.currentTimestamp + (String)(historyEntryAdded ? ", historyEntryTimestamp=" + this.historyEntryTimestamp + ", nodes=" + DistributionZonesUtil.nodeNames(nodes) : "") + (String)(historyEntryAdded ? "" : ", latestNodesWritten=" + DistributionZonesUtil.nodeNames(latestNodesWritten)) + "]" + (String)(this.scaleUpTimer == null ? "" : ", scaleUpTimer=" + this.scaleUpTimer) + (String)(this.scaleDownTimer == null ? "" : ", scaleDownTimer=" + this.scaleDownTimer) + "].";
    }

    String failureLogMessage() {
        return "Failed to update data nodes history and timers on " + this.operationName + " [timestamp=" + this.currentTimestamp + "].";
    }

    public Iif operation() {
        return Statements.iif((Condition)this.condition, (Update)new Operations(this.operations).yield(true), (Update)Operations.ops((Operation[])new Operation[0]).yield(false));
    }

    static class Builder {
        private Condition condition;
        private List<Operation> operations;
        private String operationName;
        private int zoneId = -1;
        private DataNodesHistory currentDataNodesHistory;
        private HybridTimestamp currentTimestamp;
        private HybridTimestamp historyEntryTimestamp;
        private Set<NodeWithAttributes> historyEntryNodes;
        private boolean addMandatoryEntry;
        private DistributionZoneTimer scaleUpTimer;
        private DistributionZoneTimer scaleDownTimer;

        Builder() {
        }

        Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        Builder operations(List<Operation> operations) {
            this.operations = operations;
            return this;
        }

        Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        Builder zoneId(int zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        Builder currentDataNodesHistory(DataNodesHistory currentDataNodesHistory) {
            this.currentDataNodesHistory = currentDataNodesHistory;
            return this;
        }

        Builder currentTimestamp(HybridTimestamp currentTimestamp) {
            this.currentTimestamp = currentTimestamp;
            return this;
        }

        Builder historyEntryTimestamp(HybridTimestamp historyEntryTimestamp) {
            this.historyEntryTimestamp = historyEntryTimestamp;
            return this;
        }

        Builder historyEntryNodes(Set<NodeWithAttributes> historyEntryNodes) {
            this.historyEntryNodes = historyEntryNodes;
            return this;
        }

        Builder scaleUpTimer(@Nullable DistributionZoneTimer scaleUpTimer) {
            this.scaleUpTimer = scaleUpTimer;
            return this;
        }

        Builder scaleDownTimer(@Nullable DistributionZoneTimer scaleDownTimer) {
            this.scaleDownTimer = scaleDownTimer;
            return this;
        }

        Builder addMandatoryEntry(boolean addMandatoryEntry) {
            this.addMandatoryEntry = addMandatoryEntry;
            return this;
        }

        DataNodesHistoryMetaStorageOperation build() {
            assert (this.zoneId >= 0) : "Zone id is not set.";
            assert (this.condition != null) : "Condition is not set, zoneId=" + this.zoneId;
            assert (this.operations != null) : "Meta storage operations are not set, zoneId=" + this.zoneId;
            assert (this.operationName != null) : "Operation name is not set, zoneId=" + this.zoneId;
            assert (this.currentDataNodesHistory != null) : "Current data nodes history is not set, zoneId=" + this.zoneId;
            assert (this.currentTimestamp != null) : "Current timestamp is not set, zoneId=" + this.zoneId;
            assert (this.historyEntryTimestamp != null) : "History entry timestamp is not set, zoneId=" + this.zoneId;
            assert (this.historyEntryNodes != null) : "History entry nodes are not set, zoneId=" + this.zoneId;
            return new DataNodesHistoryMetaStorageOperation(this.condition, Collections.unmodifiableList(this.operations), this.operationName, this.zoneId, this.currentDataNodesHistory, this.currentTimestamp, this.historyEntryTimestamp, this.historyEntryNodes, this.addMandatoryEntry, this.scaleUpTimer, this.scaleDownTimer);
        }
    }
}

