/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObjectImpl;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.util.GridCommandHandlerClusterPerMethodAbstractTest;
import org.junit.Test;

public class GridCommandHandlerPartitionReconciliationExtendedTest
extends GridCommandHandlerClusterPerMethodAbstractTest {
    private final ListeningTestLogger log = new ListeningTestLogger(false, GridAbstractTest.log);

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setGridLogger((IgniteLogger)this.log);
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setBackups(2)});
        return cfg;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testPartitionReconciliationCancel() throws Exception {
        LogListener lsnr = LogListener.matches(s -> s.contains("Reconciliation session has changed.")).times(3).build();
        this.log.registerListener(lsnr);
        this.startGrids(3);
        IgniteEx ignite = this.grid(0);
        ignite.cluster().active(true);
        try (IgniteDataStreamer streamer = ignite.dataStreamer("default");){
            for (int i = 0; i < 100; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        IgniteEx grid = this.grid(1);
        for (int i = 0; i < 100; ++i) {
            this.corruptDataEntry((GridCacheContext<Object, Object>)grid.cachex("default").context(), i);
        }
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((long)0L, (long)this.reconciliationSessionId());
        GridTestUtils.runAsync(() -> GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)0, (int)this.execute("--cache", "partition_reconciliation", "--repair", "MAJORITY", "--recheck-attempts", "5")));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> this.reconciliationSessionId() != 0L, (long)10000L));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)0, (int)this.execute("--cache", "partition_reconciliation_cancel"));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((long)0L, (long)this.reconciliationSessionId());
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)lsnr.check(10000L));
    }

    @Test
    @WithSystemProperty(key="RECONCILIATION_WORK_PROGRESS_PRINT_INTERVAL_SEC", value="1")
    public void testProgressLogPrinted() throws Exception {
        int nodeCnt = 3;
        this.startGrids(nodeCnt);
        IgniteEx ignite = this.grid(0);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.testProgressLogPrinted(nodeCnt, true);
        this.testProgressLogPrinted(nodeCnt, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testProgressLogPrinted(int nodeCnt, boolean simpleCollector) throws Exception {
        LogListener lsnr1 = LogListener.matches(s -> s.startsWith("Partition reconciliation status [sesId=")).atLeast(nodeCnt).build();
        LogListener lsnr2 = LogListener.matches(s -> s.startsWith("Partition reconciliation has started [sesId=")).times(nodeCnt).build();
        ArrayList finishMsgs = new ArrayList();
        LogListener lsnr3 = LogListener.matches(s -> {
            if (s.startsWith("Partition reconciliation has finished locally [sesId=")) {
                finishMsgs.add(s);
                return true;
            }
            return false;
        }).times(nodeCnt).build();
        this.log.registerListener(lsnr1);
        this.log.registerListener(lsnr2);
        this.log.registerListener(lsnr3);
        IgniteCache cache = this.grid(0).cache("default");
        int keysCnt = 100;
        int expectedConflicts = 0;
        for (int i = 0; i < keysCnt; ++i) {
            cache.put((Object)i, (Object)i);
            if (i % 10 != 0) continue;
            this.corruptDataEntry((GridCacheContext<Object, Object>)this.grid(0).cachex("default").context(), i);
            ++expectedConflicts;
        }
        try {
            ArrayList<String> args = new ArrayList<String>(Arrays.asList("--cache", "partition_reconciliation", "default", "--repair", "MAJORITY", "--recheck-attempts", "1", "--batch-size", "10", "--recheck-delay", "1"));
            if (simpleCollector) {
                args.add("--local-output");
            }
            GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)0, (int)this.execute(args.toArray(new String[0])));
            GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)lsnr1.check(10000L));
            GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)lsnr2.check(10000L));
            GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)lsnr3.check(10000L));
            Pattern pattern = Pattern.compile(".*finished locally.*conflicts=(\\d+).*repaired=(\\d+).*");
            int totalConflicts = 0;
            int totalRepaired = 0;
            for (String msg : finishMsgs) {
                Matcher matcher = pattern.matcher(msg);
                GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)matcher.matches());
                int conflicts = Integer.parseInt(matcher.group(1));
                int repaired = Integer.parseInt(matcher.group(2));
                GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((expectedConflicts >= conflicts ? 1 : 0) != 0);
                GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((expectedConflicts >= repaired ? 1 : 0) != 0);
                totalConflicts += conflicts;
                totalRepaired += repaired;
            }
            GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)expectedConflicts, (int)totalConflicts);
            GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)expectedConflicts, (int)totalRepaired);
        }
        finally {
            this.log.unregisterListener((Consumer)lsnr1);
            this.log.unregisterListener((Consumer)lsnr2);
            this.log.unregisterListener((Consumer)lsnr3);
        }
    }

    @Test
    public void testWorkWithSubsetOfCaches() throws Exception {
        HashSet<String> usedCaches = new HashSet<String>();
        LogListener lsnr = this.fillCacheNames(usedCaches);
        this.log.registerListener(lsnr);
        this.startGrids(3);
        IgniteEx ignite = this.grid(0);
        ignite.cluster().active(true);
        for (int i = 1; i <= 3; ++i) {
            ignite.getOrCreateCache("default" + i);
        }
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)0, (int)this.execute("--cache", "partition_reconciliation", "default, default3"));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)lsnr.check(10000L));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)usedCaches.containsAll(Arrays.asList("default", "default3")));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)usedCaches.size(), (int)2);
    }

    @Test
    public void testWorkWithSubsetOfCachesByRegexp() throws Exception {
        HashSet<String> usedCaches = new HashSet<String>();
        LogListener lsnr = this.fillCacheNames(usedCaches);
        this.log.registerListener(lsnr);
        this.startGrids(3);
        IgniteEx ignite = this.grid(0);
        ignite.cluster().active(true);
        for (int i = 1; i <= 3; ++i) {
            ignite.getOrCreateCache("default" + i);
        }
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)0, (int)this.execute("--cache", "partition_reconciliation", "default.*"));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)lsnr.check(10000L));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)usedCaches.containsAll(Arrays.asList("default", "default1", "default2", "default3")));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)usedCaches.size(), (int)4);
    }

    @Test
    public void testWorkWithInternalCaches() throws Exception {
        Set<String> usedCaches = this.getUsedCachesForArgs("--cache", "partition_reconciliation", "ignite-sys-cache, ignite-sys-atomic-cache@default-ds-group");
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)usedCaches.containsAll(Arrays.asList("ignite-sys-cache", "ignite-sys-atomic-cache@default-ds-group")));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)2, (int)usedCaches.size());
    }

    @Test
    public void testWorkWithSystemCachesByRegexp() throws Exception {
        Set<String> usedCaches = this.getUsedCachesForArgs("--cache", "partition_reconciliation", "ignite-sys.*");
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)usedCaches.containsAll(Arrays.asList("ignite-sys-cache", "ignite-sys-atomic-cache@default-ds-group")));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)2, (int)usedCaches.size());
    }

    @Test
    public void testWorkWithAllCaches() throws Exception {
        Set<String> usedCaches = this.getUsedCachesForArgs("--cache", "partition_reconciliation");
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)usedCaches.containsAll(Arrays.asList("ignite-sys-cache", "ignite-sys-atomic-cache@default-ds-group", "default", "default1", "default2", "default3")));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)6, (int)usedCaches.size());
    }

    @Test
    public void testWorkWithAllSetOfCachesIfParameterAbsent() throws Exception {
        HashSet<String> usedCaches = new HashSet<String>();
        LogListener lsnr = this.fillCacheNames(usedCaches);
        this.log.registerListener(lsnr);
        this.startGrids(3);
        IgniteEx ignite = this.grid(0);
        ignite.cluster().active(true);
        ArrayList<String> setOfCaches = new ArrayList<String>();
        setOfCaches.add("default");
        setOfCaches.add("ignite-sys-cache");
        for (int i = 1; i <= 3; ++i) {
            setOfCaches.add(ignite.getOrCreateCache("default" + i).getName());
        }
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)0, (int)this.execute("--cache", "partition_reconciliation"));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)lsnr.check(10000L));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)usedCaches.containsAll(setOfCaches));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)usedCaches.size(), (int)setOfCaches.size());
    }

    private Set<String> getUsedCachesForArgs(String ... args) throws Exception {
        HashSet<String> usedCaches = new HashSet<String>();
        LogListener lsnr = this.fillCacheNames(usedCaches);
        this.log.registerListener(lsnr);
        this.startGrids(3);
        IgniteEx ignite = this.grid(0);
        ignite.cluster().active(true);
        for (int i = 1; i <= 3; ++i) {
            ignite.atomicLong("default" + i, 0L, true);
            ignite.getOrCreateCache("default" + i);
        }
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)0, (int)this.execute(args));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)lsnr.check(10000L));
        this.log.unregisterListener((Consumer)lsnr);
        return usedCaches;
    }

    @Test
    public void testWrongCacheNameTerminatesOperation() throws Exception {
        String wrongCacheName = "wrong_cache_name";
        LogListener errorMsg = LogListener.matches(s -> s.contains("The cache '" + wrongCacheName + "' doesn't exist.")).atLeast(1).build();
        this.log.registerListener(errorMsg);
        this.startGrids(3);
        IgniteEx ignite = this.grid(0);
        ignite.cluster().active(true);
        Logger logger = CommandHandler.initLogger(null);
        logger.addHandler(new StreamHandler(System.out, new Formatter(){

            @Override
            public String format(LogRecord record) {
                GridCommandHandlerPartitionReconciliationExtendedTest.this.log.info(record.getMessage());
                return record.getMessage() + "\n";
            }
        }));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertEquals((int)0, (int)this.execute(new CommandHandler(logger), "--cache", "partition_reconciliation", wrongCacheName));
        GridCommandHandlerPartitionReconciliationExtendedTest.assertTrue((boolean)errorMsg.check(10000L));
    }

    private LogListener fillCacheNames(Set<String> usedCaches) {
        Pattern r = Pattern.compile("Partition reconciliation has started.*caches=\\[(.*)\\]\\].*");
        LogListener lsnr = LogListener.matches(s -> {
            Matcher m = r.matcher((CharSequence)s);
            boolean found = m.find();
            if (found && m.group(1) != null && !m.group(1).isEmpty()) {
                usedCaches.addAll(Arrays.asList(m.group(1).split(", ")));
            }
            return found;
        }).atLeast(1).build();
        return lsnr;
    }

    private long reconciliationSessionId() {
        List collect;
        List srvs = G.allGrids().stream().filter(g -> !g.configuration().getDiscoverySpi().isClientMode()).collect(Collectors.toList());
        while ((collect = srvs.stream().map(g -> ((IgniteEx)g).context().diagnostic().reconciliationExecutionContext().sessionId()).distinct().collect(Collectors.toList())).size() > 1) {
        }
        assert (collect.size() == 1);
        return (Long)collect.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void corruptDataEntry(GridCacheContext<Object, Object> ctx, Object key) {
        int partId = ctx.affinity().partition(key);
        try {
            long updateCntr = ctx.topology().localPartition(partId).updateCounter();
            Object valToPut = ctx.cache().keepBinary().get(key);
            DataEntry dataEntry = new DataEntry(ctx.cacheId(), (KeyCacheObject)new KeyCacheObjectImpl(key, null, partId), (CacheObject)new CacheObjectImpl(valToPut, null), GridCacheOperation.UPDATE, new GridCacheVersion(), new GridCacheVersion(), 0L, partId, updateCntr, 0);
            GridCacheDatabaseSharedManager db = (GridCacheDatabaseSharedManager)ctx.shared().database();
            db.checkpointReadLock();
            try {
                U.invoke(GridCacheDatabaseSharedManager.class, (Object)db, (String)"applyUpdate", (Object[])new Object[]{ctx, dataEntry, false});
            }
            finally {
                db.checkpointReadUnlock();
            }
        }
        catch (IgniteCheckedException e) {
            e.printStackTrace();
        }
    }
}

