/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.indexreader;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.jetbrains.annotations.Nullable;

public interface IgniteIndexReaderFilePageStoreFactory {
    @Nullable
    public FilePageStore createFilePageStore(int var1, byte var2, Collection<Throwable> var3) throws IgniteCheckedException;

    @Nullable
    default public FilePageStore createFilePageStoreWithEnsure(int partId, byte type, Collection<Throwable> errors) throws IgniteCheckedException {
        FilePageStore filePageStore = this.createFilePageStore(partId, type, errors);
        if (Objects.nonNull(filePageStore)) {
            filePageStore.ensure();
        }
        return filePageStore;
    }

    default public ByteBuffer headerBuffer(byte type) {
        throw new UnsupportedOperationException();
    }

    default public File getFile(File dir, int partId, @Nullable String fileExt) {
        String fileName;
        String string = fileName = partId == 65535 ? "index.bin" : String.format("part-%d.bin", partId);
        if (Objects.nonNull(fileExt) && !".bin".equals(fileExt)) {
            fileName = fileName.replace(".bin", fileExt);
        }
        return new File(dir, fileName);
    }

    public int pageSize();

    public int partitionCount();
}

