/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.dr.subcommands;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.client.util.GridClientUtils;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.argument.CommandArg;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.dr.DrSubCommandsList;
import org.apache.ignite.internal.commandline.dr.subcommands.DrAbstractRemoteSubCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrCacheCommand;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.dr.VisorDrCacheFSTTaskResult;
import org.apache.ignite.internal.visor.dr.VisorDrCacheTaskResult;
import org.apache.ignite.internal.visor.dr.VisorDrFSTCmdArgs;
import org.apache.ignite.lang.IgniteUuid;

public class DrFSTCommand
extends DrAbstractRemoteSubCommand<VisorDrFSTCmdArgs, VisorDrCacheFSTTaskResult, DrFSTArguments> {
    public static final String INC_TRANSFER_WITHOUT_DC_ERR = "Incremental state transfer is possible only if you specify single configured remote data center id";
    public static final String COMPATIBILITY_WARN = "Some nodes in cluster doesn't support extended dr fst commands. Only \"--dr full-state-transfer\" available for cluster in rolling upgrade state.";

    @Override
    public String confirmationPrompt() {
        return ((DrFSTArguments)this.arg()).legacyMode() || ((DrFSTArguments)this.arg()).action() == Action.START ? "Warning: this command will execute full state transfer for all caches. This might take a long time." : null;
    }

    @Override
    public DrFSTArguments parseArguments0(CommandArgIterator argIter) {
        if (!argIter.hasNextArg() || argIter.peekNextArg().equals("--yes")) {
            DrCacheCommand.DrCacheArguments compatibilityArgs = new DrCacheCommand.DrCacheArguments(".*", Pattern.compile(".*"), false, false, DrCacheCommand.CacheFilter.SENDING, DrCacheCommand.SenderGroup.ALL, null, DrCacheCommand.Action.FULL_STATE_TRANSFER, 0, false);
            return new DrFSTArguments(compatibilityArgs);
        }
        List<Action> actions = Arrays.asList(Action.values());
        String actionStr = argIter.nextArg("One of possible actions: " + actions + " is required.");
        Action action = CommandArgUtils.ofArg(Action.class, actionStr);
        if (action == null) {
            throw new IllegalArgumentException("Action [" + actionStr + "] not supported.");
        }
        ActionParams params = action.parseAction(argIter);
        return new DrFSTArguments(action, params);
    }

    @Override
    protected VisorDrCacheFSTTaskResult execute0(GridClientConfiguration clientCfg, GridClient client) throws Exception {
        GridClientCompute compute = client.compute();
        if (!this.allNodesSupports(compute.nodes(), IgniteFeatures.NEW_DR_FST_COMMANDS) || ((DrFSTArguments)this.arg()).legacyMode()) {
            if (((DrFSTArguments)this.arg()).legacyMode()) {
                VisorDrCacheTaskResult res = DrCacheCommand.execute0(client, ((DrFSTArguments)this.arg()).legacyArgs());
                String completionMessage = "";
                if (res.getCacheNames().isEmpty()) {
                    completionMessage = "No suitable caches found for transfer.";
                } else if (res.getResultMessages().isEmpty()) {
                    completionMessage = "Full state transfer command completed successfully for caches " + res.getCacheNames();
                }
                return new VisorDrCacheFSTTaskResult(res.getDataCenterId(), completionMessage);
            }
            throw new IgniteException(COMPATIBILITY_WARN);
        }
        Collection connectableNodes = compute.nodes(GridClientNode::connectable);
        if (F.isEmpty((Collection)(connectableNodes = GridClientUtils.applyFilter((Iterable)connectableNodes, (GridClientPredicate[])new GridClientPredicate[]{p -> p.supports(IgniteFeatures.NEW_DR_FST_COMMANDS)})))) {
            throw new GridClientDisconnectedException("Connectable nodes not found", null);
        }
        GridClientNode node = compute.balancer().balancedNode(connectableNodes);
        return (VisorDrCacheFSTTaskResult)compute.projection(node).execute(this.visorTaskName(), (Object)new VisorTaskArgument(node.nodeId(), (Object)((DrFSTArguments)this.arg()).toVisorArgs(), false));
    }

    private boolean allNodesSupports(Collection<GridClientNode> nodes, IgniteFeatures feature) {
        for (GridClientNode node : nodes) {
            if (node.supports(feature)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void printResult(VisorDrCacheFSTTaskResult res, Logger log) {
        this.printUnrecognizedNodesMessage(log, false);
        log.info("Data Center ID: " + res.dataCenterId());
        log.info("--------------------------------------------------------------------------------");
        log.info(res.resultMessage());
    }

    @Override
    public String name() {
        return DrSubCommandsList.FULL_STATE_TRANSFER.text().toUpperCase();
    }

    @Override
    protected String visorTaskName() {
        return "org.gridgain.grid.internal.visor.dr.console.VisorDrProcessFSTTask";
    }

    public static class ParseStart
    implements ParseAction<StartParams> {
        public static final String SNAPSHOT_ID = "--snapshot";
        public static final String CACHES_PARAM = "--caches";
        public static final String SENDER_GROUP = "--sender-group";
        public static final String DATA_CENTERS = "--data-centers";
        public static final String SYNC_MODE = "--sync";

        @Override
        public StartParams parse(CommandArgIterator argIter) {
            Set<String> caches = null;
            Long snapshotId = null;
            DrCacheCommand.SenderGroup sndGrp = DrCacheCommand.SenderGroup.ALL;
            String sndGrpName = null;
            HashSet<Byte> dcIds = new HashSet<Byte>();
            boolean syncMode = false;
            block14: while (argIter.hasNextSubArg()) {
                String nextArg = argIter.nextArg("");
                switch (nextArg.toLowerCase(Locale.ENGLISH)) {
                    case "--snapshot": {
                        snapshotId = argIter.nextLongArg("snapshot identificator");
                        continue block14;
                    }
                    case "--caches": {
                        caches = CommandArgUtils.validateCachesArgument(argIter.nextCachesSet(CACHES_PARAM), DrSubCommandsList.FULL_STATE_TRANSFER.toString());
                        continue block14;
                    }
                    case "--sender-group": {
                        String arg = argIter.nextArgValue(SENDER_GROUP);
                        sndGrp = CommandArgUtils.ofEnum(DrCacheCommand.SenderGroup.class, arg);
                        if (sndGrp != null) continue block14;
                        sndGrpName = arg;
                        continue block14;
                    }
                    case "--data-centers": {
                        Set<String> dcIdsStr = argIter.nextNonEmptyStringSet("set of datacenter ids for '--data-centers' parameter");
                        dcIdsStr.forEach(dc -> dcIds.add(Byte.parseByte(dc)));
                        continue block14;
                    }
                    case "--sync": {
                        syncMode = true;
                        continue block14;
                    }
                }
                throw new IllegalArgumentException("Argument " + nextArg + " is not supported.");
            }
            return new StartParams(snapshotId, caches, sndGrp, sndGrpName, dcIds, syncMode);
        }
    }

    private static class ParseCancel
    implements ParseAction<CancelParams> {
        private ParseCancel() {
        }

        @Override
        public CancelParams parse(CommandArgIterator argIter) {
            String operationId = argIter.nextArg("Expected full state transfer ID.");
            return new CancelParams(IgniteUuid.fromString((String)operationId));
        }
    }

    private static class ParseNone
    implements ParseAction<ActionParams> {
        private ParseNone() {
        }

        @Override
        public ActionParams parse(CommandArgIterator argIter) {
            if (argIter.hasNextArg() && !argIter.peekNextArg().equals("--yes")) {
                throw new IllegalArgumentException("Unexpected params: " + argIter.peekNextArg());
            }
            return null;
        }
    }

    private static interface ParseAction<T extends ActionParams> {
        public T parse(CommandArgIterator var1);
    }

    private static class StartParams
    implements ActionParams {
        private long snapshotId;
        private Set<String> caches;
        private DrCacheCommand.SenderGroup senderGroup;
        private String senderGroupName;
        private Set<Byte> dcIds;
        private boolean syncMode;

        StartParams() {
        }

        StartParams(Long snapshotId, Set<String> caches, DrCacheCommand.SenderGroup senderGroup, String senderGroupName, Set<Byte> dcIds, boolean syncMode) {
            if (snapshotId != null && dcIds.size() != 1) {
                throw new IllegalArgumentException(DrFSTCommand.INC_TRANSFER_WITHOUT_DC_ERR);
            }
            this.snapshotId = snapshotId == null ? -1L : snapshotId;
            this.caches = caches;
            this.senderGroup = senderGroup;
            this.senderGroupName = senderGroupName;
            this.dcIds = dcIds;
            this.syncMode = syncMode;
        }

        public Set<String> caches() {
            return this.caches;
        }

        public long snapshotId() {
            return this.snapshotId;
        }

        public DrCacheCommand.SenderGroup senderGroup() {
            return this.senderGroup;
        }

        public String senderGroupName() {
            return this.senderGroupName;
        }

        public Set<Byte> dcIds() {
            return this.dcIds;
        }

        public boolean isSyncMode() {
            return this.syncMode;
        }
    }

    private static class CancelParams
    implements ActionParams {
        private IgniteUuid operationId;

        CancelParams(IgniteUuid operationId) {
            this.operationId = operationId;
        }

        public IgniteUuid operationId() {
            return this.operationId;
        }
    }

    private static interface ActionParams {
    }

    public static enum Action implements CommandArg
    {
        START("start", new ParseStart()),
        CANCEL("cancel", new ParseCancel()),
        LIST("list", new ParseNone());

        private final String name;
        private final ParseAction parseAction;

        private Action(String item, ParseAction parseAction) {
            this.name = item;
            this.parseAction = parseAction;
        }

        @Override
        public String argName() {
            return this.name;
        }

        public ActionParams parseAction(CommandArgIterator argIter) {
            return this.parseAction.parse(argIter);
        }

        public String toString() {
            return this.name;
        }
    }

    static class DrFSTArguments
    implements DrAbstractRemoteSubCommand.Arguments<VisorDrFSTCmdArgs> {
        private DrCacheCommand.DrCacheArguments legacyArgs;
        private boolean legacyMode;
        private Action action;
        private ActionParams params;

        public DrFSTArguments(DrCacheCommand.DrCacheArguments legacyArgs) {
            A.notNull((Object)legacyArgs, (String)"compatibilityArgs");
            this.legacyArgs = legacyArgs;
            this.legacyMode = true;
        }

        public DrFSTArguments(Action action, ActionParams params) {
            this.action = action;
            this.params = params;
            this.legacyMode = false;
        }

        @Override
        public VisorDrFSTCmdArgs toVisorArgs() {
            switch (this.action) {
                case LIST: {
                    return new VisorDrFSTCmdArgs(this.action.ordinal(), null);
                }
                case START: {
                    StartParams params0 = (StartParams)this.params;
                    return new VisorDrFSTCmdArgs(this.action.ordinal(), params0.caches(), params0.snapshotId(), params0.dcIds(), params0.senderGroup() == null ? 3 : params0.senderGroup().ordinal(), params0.senderGroupName(), params0.isSyncMode());
                }
                case CANCEL: {
                    CancelParams params0 = (CancelParams)this.params;
                    return new VisorDrFSTCmdArgs(this.action.ordinal(), params0.operationId());
                }
            }
            throw new IllegalArgumentException("Action [" + this.action.argName() + "] not supported.");
        }

        public boolean legacyMode() {
            return this.legacyMode;
        }

        public DrCacheCommand.DrCacheArguments legacyArgs() {
            return this.legacyArgs;
        }

        public Action action() {
            return this.action;
        }

        public String toString() {
            return S.toString(DrAbstractRemoteSubCommand.Arguments.class, (Object)this);
        }
    }
}

