/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.dr;

import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.dr.DrSubCommandsList;
import org.apache.ignite.internal.commandline.dr.subcommands.DrCacheCommand;
import org.apache.ignite.internal.commandline.dr.subcommands.DrFSTCommand;

public class DrCommand
extends AbstractCommand<Object> {
    private Command<?> delegate;

    @Override
    public void printUsage(Logger log) {
        Command.usage(log, "Print data center replication command help:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.HELP.toString());
        Command.usage(log, "Print state of data center replication:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.STATE.toString(), CommandLogger.optional("--verbose"));
        Command.usage(log, "Print topology of the cluster with the data center replication related details:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.TOPOLOGY.toString(), CommandLogger.optional("--sender-hubs"), CommandLogger.optional("--receiver-hubs"), CommandLogger.optional("--data-nodes"), CommandLogger.optional("--other-nodes"));
        Command.usage(log, "Print node specific data center replication related details and clear node's DR store:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.NODE.toString(), "<nodeId>", CommandLogger.optional("--config"), CommandLogger.optional("--metrics"), CommandLogger.optional("--clear-store"), CommandLogger.optional("--yes"));
        Command.usage(log, "Print cache specific data center replication related details about caches and maybe change replication state on them:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.CACHE.toString(), "<regExp>", CommandLogger.optional("--config"), CommandLogger.optional("--metrics"), CommandLogger.optional("--cache-filter", CommandLogger.join("|", DrCacheCommand.CacheFilter.values())), CommandLogger.optional("--sender-group", "<groupName>|" + CommandLogger.join("|", DrCacheCommand.SenderGroup.values())), CommandLogger.optional("--action", DrCacheCommand.Action.START.argName() + "|" + DrCacheCommand.Action.STOP.argName()), CommandLogger.optional("--yes"));
        Command.usage(log, "Deprecated command to start full state transfer:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.CACHE.toString(), "<regExp> --action full-state-transfer", CommandLogger.optional("--sync"), CommandLogger.optional("--yes"));
        Command.usage(log, "Execute full state transfer, transfer all caches if not specified in params and data center is configured:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.FULL_STATE_TRANSFER.toString(), CommandLogger.optional(DrFSTCommand.Action.START.argName()), CommandLogger.optional("--snapshot", "<snapshotId>"), CommandLogger.optional("--caches", "<cacheName1, ...>"), CommandLogger.optional("--sender-group", "<groupName>|ALL|DEFAULT|NONE"), CommandLogger.optional("--data-centers", "<dcId, ...>"), CommandLogger.optional("--sync"), CommandLogger.optional("--yes"));
        Command.usage(log, "Cancel active full state transfer by id:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.FULL_STATE_TRANSFER.toString(), DrFSTCommand.Action.CANCEL.argName(), "<fullStateTransferUID>", CommandLogger.optional("--yes"));
        Command.usage(log, "Print list of active full state transfers:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.FULL_STATE_TRANSFER.toString(), DrFSTCommand.Action.LIST.argName());
        Command.usage(log, "Stop data center replication on all caches in cluster:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.PAUSE.toString(), "<remoteDataCenterId>", CommandLogger.optional("--yes"));
        Command.usage(log, "Start data center replication on all caches in cluster:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.RESUME.toString(), "<remoteDataCenterId>", CommandLogger.optional("--yes"));
        Command.usage(log, "Start partition counters check for selected caches:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.CHECK.toString(), CommandLogger.optional("--caches", "cacheName1,cacheName2,...,cacheNameN"), CommandLogger.optional("--check-first"), CommandLogger.optional("--scan-until-first-error"), CommandLogger.optional("--yes"));
        Command.usage(log, "Start partition counters repairing for selected caches:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.REPAIR.toString(), CommandLogger.optional("--caches", "cacheName1,cacheName2,...,cacheNameN"), CommandLogger.optional("--batch-size"), CommandLogger.optional("--keep-binary"), CommandLogger.optional("--yes"));
        Command.usage(log, "Schedule/run maintenance task for rebuilding DR tries:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.REBUILD_TREES.toString(), CommandLogger.optional("--caches", "cacheName1,cacheName2,...,cacheNameN"), CommandLogger.optional("--groups", "groupName1,groupName2,...,groupNameN"), CommandLogger.optional("--yes"));
        Command.usage(log, "Schedule/run maintenance task for cleanup DR tries:", CommandList.DATA_CENTER_REPLICATION, DrSubCommandsList.CLEANUP_TREES.toString(), CommandLogger.optional("--caches", "cacheName1,cacheName2,...,cacheNameN"), CommandLogger.optional("--groups", "groupName1,groupName2,...,groupNameN"), CommandLogger.optional("--nodes", "consistentId0,consistentId1,...,consistentIdN"), CommandLogger.optional("--yes"));
    }

    @Override
    public String name() {
        return CommandList.DATA_CENTER_REPLICATION.toCommandName();
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        DrSubCommandsList subcommand = DrSubCommandsList.parse(argIter.nextArg("Expected dr action."));
        if (subcommand == null) {
            throw new IllegalArgumentException("Expected correct dr action.");
        }
        this.delegate = subcommand.command();
        this.delegate.parseArguments(argIter);
    }

    @Override
    public String confirmationPrompt() {
        return this.delegate != null ? this.delegate.confirmationPrompt() : null;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        return this.delegate.execute(clientCfg, log);
    }

    @Override
    public Object arg() {
        return this.delegate.arg();
    }
}

