/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.argument.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.commandline.argument.parser.CLIArgument;
import org.apache.ignite.internal.util.GridStringBuilder;

public class CLIArgumentParser {
    private final Map<String, CLIArgument> argConfiguration = new LinkedHashMap<String, CLIArgument>();
    private final Map<String, Object> parsedArgs = new HashMap<String, Object>();

    public CLIArgumentParser(List<CLIArgument> argConfiguration) {
        for (CLIArgument cliArgument : argConfiguration) {
            this.argConfiguration.put(cliArgument.name(), cliArgument);
        }
    }

    public void parse(Iterator<String> argsIter) {
        Set obligatoryArgs = this.argConfiguration.values().stream().filter(a -> !a.optional()).map(CLIArgument::name).collect(Collectors.toSet());
        while (argsIter.hasNext()) {
            String arg = argsIter.next();
            CLIArgument cliArg = this.argConfiguration.get(arg);
            if (cliArg == null) {
                throw new IgniteException("Unexpected argument: " + arg);
            }
            if (cliArg.type().equals(Boolean.class)) {
                this.parsedArgs.put(cliArg.name(), true);
            } else {
                if (!argsIter.hasNext()) {
                    throw new IgniteException("Please specify a value for argument: " + arg);
                }
                String strVal = argsIter.next();
                this.parsedArgs.put(cliArg.name(), this.parseVal(strVal, cliArg.type()));
            }
            obligatoryArgs.remove(cliArg.name());
        }
        if (!obligatoryArgs.isEmpty()) {
            throw new IgniteException("Mandatory argument(s) missing: " + obligatoryArgs);
        }
    }

    private Object parseVal(String val, Class type) {
        switch (type.getSimpleName()) {
            case "String": {
                return val;
            }
            case "String[]": {
                return val.split(",");
            }
            case "Integer": {
                return this.wrapNumberFormatException(() -> Integer.parseInt(val), val, Integer.class);
            }
            case "Long": {
                return this.wrapNumberFormatException(() -> Long.parseLong(val), val, Long.class);
            }
            case "UUID": {
                return UUID.fromString(val);
            }
        }
        throw new IgniteException("Unsupported argument type: " + type.getName());
    }

    private Object wrapNumberFormatException(Supplier<Object> closure, String val, Class<? extends Number> expectedType) {
        try {
            return closure.get();
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Can't parse number '" + val + "', expected type: " + expectedType.getName());
        }
    }

    public <T> T get(CLIArgument arg) {
        Object val = this.parsedArgs.get(arg.name());
        if (val == null) {
            return arg.defaultValueSupplier().apply(this);
        }
        return (T)val;
    }

    public <T> T get(String name) {
        CLIArgument arg = this.argConfiguration.get(name);
        if (arg == null) {
            throw new IgniteException("No such argument: " + name);
        }
        return this.get(arg);
    }

    public String usage() {
        GridStringBuilder sb = new GridStringBuilder("Usage: ");
        for (CLIArgument arg : this.argConfiguration.values()) {
            sb.a(this.argNameForUsage(arg)).a(" ");
        }
        for (CLIArgument arg : this.argConfiguration.values()) {
            Object dfltVal = null;
            try {
                dfltVal = arg.defaultValueSupplier().apply(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.a("\n\n").a(arg.name()).a(": ").a(arg.usage());
            if (!arg.optional()) continue;
            sb.a(" Default value: ").a(dfltVal);
        }
        return sb.toString();
    }

    private String argNameForUsage(CLIArgument arg) {
        if (arg.optional()) {
            return "[" + arg.name() + "]";
        }
        return arg.name();
    }
}

