/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.internal.SupportFeaturesUtils;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.util.TopologyUtils;
import org.apache.ignite.internal.visor.id_and_tag.VisorClusterChangeIdTask;
import org.apache.ignite.internal.visor.id_and_tag.VisorClusterChangeIdTaskArg;
import org.apache.ignite.internal.visor.id_and_tag.VisorClusterChangeIdTaskResult;

public class ClusterChangeIdCommand
extends AbstractCommand<UUID> {
    private UUID newIdArg;

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        if (!SupportFeaturesUtils.isFeatureEnabled((String)"IGNITE_CLUSTER_ID_AND_TAG_FEATURE")) {
            return null;
        }
        try (GridClient client = Command.startClient(clientCfg);){
            UUID coordinatorId = TopologyUtils.coordinatorId(client.compute());
            VisorClusterChangeIdTaskResult res = (VisorClusterChangeIdTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorClusterChangeIdTask.class.getName(), this.toVisorArguments(), coordinatorId, clientCfg);
            logger.info("Cluster ID changed successfully, previous ID was: " + res.oldId());
        }
        catch (Throwable e) {
            logger.severe("Failed to change cluster ID: ");
            logger.severe(CommandLogger.errorMessage(e));
            throw e;
        }
        return null;
    }

    @Override
    public UUID arg() {
        return this.newIdArg;
    }

    @Override
    public void printUsage(Logger logger) {
        if (!SupportFeaturesUtils.isFeatureEnabled((String)"IGNITE_CLUSTER_ID_AND_TAG_FEATURE")) {
            return;
        }
        Command.usage(logger, "Change cluster ID to new value:", CommandList.CLUSTER_CHANGE_ID, "newIdValue", CommandLogger.optional("--yes"));
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        if (!argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Please provide new ID.");
        }
        this.newIdArg = argIter.nextUuidArg("cluster ID");
    }

    @Override
    public String name() {
        return CommandList.CLUSTER_CHANGE_ID.toCommandName();
    }

    @Override
    public String confirmationPrompt() {
        return "Warning: the command will change cluster ID.";
    }

    private VisorClusterChangeIdTaskArg toVisorArguments() {
        return new VisorClusterChangeIdTaskArg(this.newIdArg);
    }
}

