/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerClusterByClassAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class GridCommandHandlerResetLostPartitionTest
extends GridCommandHandlerClusterByClassAbstractTest {
    private static final String CACHE_WITH_CUSTOM_GROUP = "cacheCustomGroupName";
    private static final String CACHE_WITH_SHARED_GROUP_I = "cacheSharedGroupI";
    private static final String CACHE_WITH_SHARED_GROUP_II = "cacheSharedGroupII";
    private static final String CUSTOM_CACHE_GROUP_NAME = "customGroupName";
    private static final String SHARED_CACHE_GROUP_NAME = "sharedGroupName";
    private static final String[] CACHE_NAMES = new String[]{"cacheOne", "cacheTwo", "cacheThree", "cacheCustomGroupName", "cacheSharedGroupI", "cacheSharedGroupII"};
    private static final String[] CACHE_GROUP_NAMES = new String[]{null, null, null, "customGroupName", "sharedGroupName", "sharedGroupName"};
    public static final int CACHE_SIZE = 10000 / CACHE_NAMES.length;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName).setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi());
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        DataStorageConfiguration storageCfg = new DataStorageConfiguration();
        storageCfg.setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0x6400000L));
        cfg.setDataStorageConfiguration(storageCfg);
        CacheConfiguration[] ccfg = new CacheConfiguration[CACHE_NAMES.length];
        for (int i = 0; i < CACHE_NAMES.length; ++i) {
            ccfg[i] = this.cacheConfiguration(CACHE_NAMES[i], CACHE_GROUP_NAMES[i], CacheAtomicityMode.ATOMIC);
        }
        cfg.setCacheConfiguration(ccfg);
        return cfg;
    }

    private CacheConfiguration<Object, Object> cacheConfiguration(String cacheName, @Nullable String groupName, CacheAtomicityMode mode) {
        return new CacheConfiguration(cacheName).setGroupName(groupName).setCacheMode(CacheMode.PARTITIONED).setAtomicityMode(mode).setBackups(1).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setPartitionLossPolicy(PartitionLossPolicy.READ_ONLY_SAFE).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setIndexedTypes(new Class[]{String.class, String.class});
    }

    @Test
    public void testCacheResetLostPartitionsAll() throws Exception {
        this.injectTestSystemOut();
        this.doRebalanceAfterPartitionsWereLost();
        AffinityTopologyVersion initTopVer = this.grid(0).context().discovery().topologyVersionEx();
        final ConcurrentHashMap cachesToResetLostParts = new ConcurrentHashMap();
        this.grid(0).context().cache().context().exchange().registerExchangeAwareComponent(new PartitionsExchangeAware(){

            public void onInitBeforeTopologyLock(GridDhtPartitionsExchangeFuture fut) {
                Set res = fut.exchangeActions() != null ? fut.exchangeActions().cachesToResetLostPartitions() : Collections.emptySet();
                cachesToResetLostParts.put(fut.initialVersion(), res);
            }
        });
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)0, (int)this.execute("--cache", "reset_lost_partitions", "--all"));
        AffinityTopologyVersion resetLostPartsTopVer = initTopVer.nextMinorVersion();
        AffinityTopologyVersion lateAffAssignmentTopVer = resetLostPartsTopVer.nextMinorVersion();
        GridCommandHandlerResetLostPartitionTest.assertTrue((String)("Failed to wait for late affinity assignment message [currTopVer=" + this.grid(0).context().discovery().topologyVersionEx() + ", expectedTopVer=" + lateAffAssignmentTopVer + ']'), (boolean)GridTestUtils.waitForCondition(() -> {
            AffinityTopologyVersion curTopVer = this.grid(0).context().discovery().topologyVersionEx();
            return curTopVer.equals((Object)lateAffAssignmentTopVer);
        }, (long)10000L));
        GridCommandHandlerResetLostPartitionTest.assertNotNull((String)("Failed to find a collection of cache names to reset lost partitions [topVer=" + resetLostPartsTopVer + ']'), cachesToResetLostParts.get(resetLostPartsTopVer));
        for (String cacheName : CACHE_NAMES) {
            GridCommandHandlerResetLostPartitionTest.assertTrue((String)("Failed to find a cache to reset lost partitions [name=" + cacheName + ']'), (boolean)((Set)cachesToResetLostParts.get(resetLostPartsTopVer)).contains(cacheName));
        }
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"The following caches have LOST partitions: [cacheTwo, cacheSharedGroupI, cacheThree, cacheSharedGroupII, cacheCustomGroupName, cacheOne].");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Reset LOST-partitions performed successfully. Cache group (name = 'cacheOne', id = -433504380), caches ([cacheOne]).");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Reset LOST-partitions performed successfully. Cache group (name = 'cacheTwo', id = -433499286), caches ([cacheTwo]).");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Reset LOST-partitions performed successfully. Cache group (name = 'cacheThree', id = 18573116), caches ([cacheThree]).");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Reset LOST-partitions performed successfully. Cache group (name = 'sharedGroupName', id = 912335557), caches ([cacheSharedGroupI, cacheSharedGroupII]).");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Reset LOST-partitions performed successfully. Cache group (name = 'customGroupName', id = 1292595513), caches ([cacheCustomGroupName]).");
        for (String cacheName : CACHE_NAMES) {
            for (Ignite grid : G.allGrids()) {
                GridCommandHandlerResetLostPartitionTest.assertTrue((boolean)grid.cache(cacheName).lostPartitions().isEmpty());
            }
        }
        this.stopAllGrids();
        this.startGrids(3);
        this.awaitPartitionMapExchange();
        crd = this.grid(0);
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)(CACHE_NAMES.length * CACHE_SIZE), (int)this.averageSizeAroundAllNodes());
    }

    @Test
    public void testResetLostPartitionsSystemCache() throws Exception {
        IgniteEx g0 = this.startGrids(2);
        g0.cluster().state(ClusterState.ACTIVE);
        this.stopGrid(1);
        IgniteInternalCache sysCache0 = g0.context().cache().utilityCache();
        int keyNums = sysCache0.configuration().getAffinity().partitions() * 10;
        for (int i = 0; i < keyNums; ++i) {
            sysCache0.put((Object)i, (Object)i);
        }
        TestRecordingCommunicationSpi spi0 = TestRecordingCommunicationSpi.spi((Ignite)g0);
        spi0.blockMessages(TestRecordingCommunicationSpi.blockSupplyMessageForGroup((int)CU.cacheId((String)"ignite-sys-cache")));
        IgniteInternalFuture startFut = GridTestUtils.runAsync(() -> this.startGrid(1));
        spi0.waitForBlocked();
        this.stopGrid(0);
        spi0.stopBlock(false);
        startFut.get();
        crd = this.grid(1);
        IgniteInternalCache sysCache1 = this.grid(1).context().cache().utilityCache();
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)sysCache1.configuration().getAffinity().partitions(), (int)sysCache1.lostPartitions().size());
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)0, (int)this.execute("--port", this.grid(1).localNode().attribute("org.apache.ignite.rest.tcp.port").toString(), "--cache", "reset_lost_partitions", "ignite-sys-cache"));
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)0, (int)sysCache1.lostPartitions().size());
    }

    @Test
    public void testResetLostPartitionsCustomCacheGroup() throws Exception {
        IgniteEx g0 = this.startGrids(2);
        g0.cluster().state(ClusterState.ACTIVE);
        this.stopGrid(1);
        IgniteCache userCache = g0.cache(CACHE_WITH_CUSTOM_GROUP);
        int keyNums = g0.affinity(CACHE_WITH_CUSTOM_GROUP).partitions() * 10;
        for (int i = 0; i < keyNums; ++i) {
            userCache.put((Object)i, (Object)i);
        }
        TestRecordingCommunicationSpi spi0 = TestRecordingCommunicationSpi.spi((Ignite)g0);
        spi0.blockMessages(TestRecordingCommunicationSpi.blockSupplyMessageForGroup((int)GridCacheUtils.cacheGroupId((String)CACHE_WITH_CUSTOM_GROUP, (String)CUSTOM_CACHE_GROUP_NAME)));
        IgniteInternalFuture startFut = GridTestUtils.runAsync(() -> this.startGrid(1));
        spi0.waitForBlocked();
        this.stopGrid(0);
        spi0.stopBlock(false);
        startFut.get();
        crd = this.grid(1);
        IgniteCache userCache1 = this.grid(1).cache(CACHE_WITH_CUSTOM_GROUP);
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)this.grid(1).affinity(CACHE_WITH_CUSTOM_GROUP).partitions(), (int)userCache1.lostPartitions().size());
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)0, (int)this.execute("--port", this.grid(1).localNode().attribute("org.apache.ignite.rest.tcp.port").toString(), "--cache", "reset_lost_partitions", CACHE_WITH_CUSTOM_GROUP));
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)0, (int)userCache1.lostPartitions().size());
    }

    @Test
    public void testResetLostPartitionsSharedCacheGroup() throws Exception {
        IgniteEx g0 = this.startGrids(2);
        g0.cluster().state(ClusterState.ACTIVE);
        this.stopGrid(1);
        IgniteCache userCache1 = g0.cache(CACHE_WITH_SHARED_GROUP_I);
        IgniteCache userCache2 = g0.cache(CACHE_WITH_SHARED_GROUP_II);
        int keyNums = g0.affinity(CACHE_WITH_SHARED_GROUP_I).partitions() * 10;
        for (int i = 0; i < keyNums; ++i) {
            userCache1.put((Object)i, (Object)i);
            userCache2.put((Object)i, (Object)i);
        }
        TestRecordingCommunicationSpi spi0 = TestRecordingCommunicationSpi.spi((Ignite)g0);
        spi0.blockMessages(TestRecordingCommunicationSpi.blockSupplyMessageForGroup((int)GridCacheUtils.cacheGroupId((String)CACHE_WITH_SHARED_GROUP_I, (String)SHARED_CACHE_GROUP_NAME)));
        IgniteInternalFuture startFut = GridTestUtils.runAsync(() -> this.startGrid(1));
        spi0.waitForBlocked();
        this.stopGrid(0);
        spi0.stopBlock(false);
        startFut.get();
        crd = this.grid(1);
        userCache1 = this.grid(1).cache(CACHE_WITH_SHARED_GROUP_I);
        userCache2 = this.grid(1).cache(CACHE_WITH_SHARED_GROUP_II);
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)this.grid(1).affinity(CACHE_WITH_SHARED_GROUP_I).partitions(), (int)userCache1.lostPartitions().size());
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)this.grid(1).affinity(CACHE_WITH_SHARED_GROUP_II).partitions(), (int)userCache2.lostPartitions().size());
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)0, (int)this.execute("--port", this.grid(1).localNode().attribute("org.apache.ignite.rest.tcp.port").toString(), "--cache", "reset_lost_partitions", "cacheSharedGroupI, cacheSharedGroupII"));
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)0, (int)userCache1.lostPartitions().size());
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)0, (int)userCache2.lostPartitions().size());
    }

    private void doRebalanceAfterPartitionsWereLost() throws Exception {
        this.startGrids(3);
        this.grid(0).cluster().state(ClusterState.ACTIVE);
        for (String cacheName : CACHE_NAMES) {
            TreeMap<String, String> putMap = new TreeMap<String, String>();
            for (int i = 0; i < CACHE_SIZE; ++i) {
                putMap.put(Integer.toString(i), "Value" + i);
            }
            this.grid(0).cache(cacheName).putAll(putMap);
        }
        String g1Name = this.grid(1).name();
        this.stopGrid(1);
        this.cleanPersistenceDir(g1Name);
        GridCommandHandlerResetLostPartitionTest.assertEquals((int)(CACHE_NAMES.length * CACHE_SIZE), (int)this.averageSizeAroundAllNodes());
        final IgniteConfiguration cfg1 = this.getConfiguration(this.getTestIgniteInstanceName(1));
        TestRecordingCommunicationSpi spi1 = (TestRecordingCommunicationSpi)cfg1.getCommunicationSpi();
        spi1.blockMessages((IgniteBiPredicate)new IgniteBiPredicate<ClusterNode, Message>(){

            public boolean apply(ClusterNode clusterNode, Message msg) {
                if (msg instanceof GridDhtPartitionDemandMessage) {
                    GridDhtPartitionDemandMessage msg0 = (GridDhtPartitionDemandMessage)msg;
                    return msg0.groupId() != CU.cacheId((String)"ignite-sys-cache");
                }
                return false;
            }
        });
        GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GridCommandHandlerResetLostPartitionTest.this.startGrid(cfg1);
                return null;
            }
        });
        spi1.waitForBlocked();
        this.stopGrid(2);
        spi1.stopBlock();
        this.startGrid(2);
        GridCommandHandlerResetLostPartitionTest.assertTrue((CACHE_NAMES.length * CACHE_SIZE > this.averageSizeAroundAllNodes() ? 1 : 0) != 0);
        for (String cacheName : CACHE_NAMES) {
            Collection lost = null;
            for (Ignite grid : G.allGrids()) {
                if (lost == null) {
                    lost = grid.cache(cacheName).lostPartitions();
                    continue;
                }
                GridCommandHandlerResetLostPartitionTest.assertEquals((Object)lost, (Object)grid.cache(cacheName).lostPartitions());
            }
            GridCommandHandlerResetLostPartitionTest.assertTrue((lost != null && !lost.isEmpty() ? 1 : 0) != 0);
        }
    }

    private int averageSizeAroundAllNodes() {
        int totalSize = 0;
        for (Ignite ignite : IgnitionEx.allGrids()) {
            for (String cacheName : CACHE_NAMES) {
                totalSize += ignite.cache(cacheName).size(new CachePeekMode[0]);
            }
        }
        return totalSize / IgnitionEx.allGrids().size();
    }
}

