/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.Serializable;
import java.util.Set;
import java.util.TimeZone;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedProperty;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerClusterByClassAbstractTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class GridCommandHandlerPropertiesTest
extends GridCommandHandlerClusterByClassAbstractTest {
    @Before
    public void init() {
        this.injectTestSystemOut();
    }

    @After
    public void clear() {
    }

    @Test
    public void testHelp() {
        GridCommandHandlerPropertiesTest.assertEquals((int)0, (int)this.execute("--property", "help"));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Print property command help:");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"control.(sh|bat) --property help");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Print list of available properties:");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"control.(sh|bat) --property list");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Get the property value:");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"control.(sh|bat) --property get --name <property_name>");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Set the property value:");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"control.(sh|bat) --property set --name <property_name> --val <property_value>");
    }

    @Test
    public void testList() {
        GridCommandHandlerPropertiesTest.assertEquals((int)0, (int)this.execute("--property", "list"));
        String out = testOut.toString();
        for (DistributedChangeableProperty pd : crd.context().distributedConfiguration().properties()) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)pd.getName());
        }
    }

    @Test
    public void testGet() {
        for (DistributedChangeableProperty pd : crd.context().distributedConfiguration().properties()) {
            GridCommandHandlerPropertiesTest.assertEquals((int)0, (int)this.execute("--property", "get", "--name", pd.getName()));
            String out = testOut.toString();
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)(pd.getName() + " = " + pd.get()));
        }
    }

    @Test
    public void testPropertyDisabledSqlFunctions() {
        GridCommandHandlerPropertiesTest.assertEquals((int)0, (int)this.execute("--property", "set", "--name", "sql.disabledFunctions", "--val", "LENGTH, SESSION_ID"));
        for (Ignite ign : G.allGrids()) {
            Set disabledFuncs = ((IgniteH2Indexing)((IgniteEx)ign).context().query().getIndexing()).distributedConfiguration().disabledFunctions();
            GridCommandHandlerPropertiesTest.assertEquals((int)2, (int)disabledFuncs.size());
            GridCommandHandlerPropertiesTest.assertTrue((boolean)disabledFuncs.contains("LENGTH"));
            GridCommandHandlerPropertiesTest.assertTrue((boolean)disabledFuncs.contains("SESSION_ID"));
        }
    }

    @Test
    public void testPropertyCheckpointDeviation() {
        DistributedProperty cpFreqDeviation;
        for (Ignite ign : G.allGrids()) {
            if (ign.configuration().isClientMode().booleanValue()) continue;
            cpFreqDeviation = (DistributedProperty)U.field((Object)((IgniteEx)ign).context().cache().context().database(), (String)"cpFreqDeviation");
            GridCommandHandlerPropertiesTest.assertNull((Object)cpFreqDeviation.get());
        }
        GridCommandHandlerPropertiesTest.assertEquals((int)0, (int)this.execute("--property", "set", "--name", "checkpoint.deviation", "--val", "20"));
        for (Ignite ign : G.allGrids()) {
            if (ign.configuration().isClientMode().booleanValue()) continue;
            cpFreqDeviation = (DistributedProperty)U.field((Object)((IgniteEx)ign).context().cache().context().database(), (String)"cpFreqDeviation");
            GridCommandHandlerPropertiesTest.assertNotNull((Object)cpFreqDeviation.get());
            GridCommandHandlerPropertiesTest.assertEquals((int)20, (int)((Integer)cpFreqDeviation.get()));
        }
    }

    @Test
    public void testPropertyCheckpointFrequency() throws Exception {
        for (Ignite ign : G.allGrids()) {
            if (ign.configuration().isClientMode().booleanValue()) continue;
            DistributedProperty cpFreq = (DistributedProperty)U.field((Object)((IgniteEx)ign).context().cache().context().database(), (String)"cpFreq");
            GridCommandHandlerPropertiesTest.assertNull((Object)cpFreq.get());
        }
        GridCommandHandlerPropertiesTest.assertEquals((int)0, (int)this.execute("--property", "set", "--name", "checkpoint.frequency", "--val", "21000"));
        for (Ignite ign : G.allGrids()) {
            if (ign.configuration().isClientMode().booleanValue()) continue;
            GridCacheDatabaseSharedManager database = (GridCacheDatabaseSharedManager)((IgniteEx)ign).context().cache().context().database();
            DistributedProperty cpFreq = (DistributedProperty)U.field((Object)database, (String)"cpFreq");
            GridCommandHandlerPropertiesTest.assertNotNull((Object)cpFreq.get());
            GridCommandHandlerPropertiesTest.assertEquals((long)21000L, (long)((Long)cpFreq.get()));
            long nextCpInterval = GridCommandHandlerPropertiesTest.nextCpInterval((IgniteEx)ign);
            GridCommandHandlerPropertiesTest.assertEquals((long)21000L, (long)nextCpInterval);
        }
    }

    private static long nextCpInterval(IgniteEx ignite) throws Exception {
        GridCacheDatabaseSharedManager database = (GridCacheDatabaseSharedManager)ignite.context().cache().context().database();
        return (Long)GridTestUtils.invoke((Object)database.getCheckpointer(), (String)"nextCheckpointInterval", (Object[])new Object[0]);
    }

    @Test
    public void nonPositiveCheckpointFrequencyOverrideIsIgnored() throws Exception {
        GridCommandHandlerPropertiesTest.assertEquals((int)0, (int)this.execute("--property", "set", "--name", "checkpoint.frequency", "--val", "0"));
        GridCommandHandlerPropertiesTest.assertThatNextCpIntervalIsPositive();
        GridCommandHandlerPropertiesTest.assertEquals((int)0, (int)this.execute("--property", "set", "--name", "checkpoint.frequency", "--val", "-1"));
        GridCommandHandlerPropertiesTest.assertThatNextCpIntervalIsPositive();
    }

    private static void assertThatNextCpIntervalIsPositive() throws Exception {
        for (Ignite ign : G.allGrids()) {
            if (ign.configuration().isClientMode().booleanValue()) continue;
            long nextCpInterval = GridCommandHandlerPropertiesTest.nextCpInterval((IgniteEx)ign);
            MatcherAssert.assertThat((Object)nextCpInterval, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L))));
        }
    }

    @Test
    public void testPropertyDefaultQueryTimeout() {
        int dfltVal = ((IgniteH2Indexing)crd.context().query().getIndexing()).distributedConfiguration().defaultQueryTimeout();
        int newVal = dfltVal + 1000;
        GridCommandHandlerPropertiesTest.assertEquals((int)0, (int)this.execute("--property", "set", "--name", "sql.defaultQueryTimeout", "--val", Integer.toString(newVal)));
        for (Ignite ign : G.allGrids()) {
            GridCommandHandlerPropertiesTest.assertEquals((String)("Invalid default query timeout on node: " + ign.name()), (int)newVal, (int)((IgniteH2Indexing)((IgniteEx)ign).context().query().getIndexing()).distributedConfiguration().defaultQueryTimeout());
        }
        GridCommandHandlerPropertiesTest.assertEquals((int)4, (int)this.execute("--property", "set", "--name", "sql.defaultQueryTimeout", "--val", "invalidVal"));
    }

    @Test
    public void testPropertyTimeZone() {
        TimeZone newVal = TimeZone.getTimeZone("PST");
        GridCommandHandlerPropertiesTest.assertEquals((int)0, (int)this.execute("--property", "set", "--name", "sql.timeZone", "--val", newVal.getID()));
        for (Ignite ign : G.allGrids()) {
            GridCommandHandlerPropertiesTest.assertEquals((String)("Invalid time zone on node: " + ign.name()), (Object)newVal, (Object)((IgniteH2Indexing)((IgniteEx)ign).context().query().getIndexing()).distributedConfiguration().timeZone());
        }
    }

    @Test
    public void testPropertyWalRebalanceThreshold() {
        this.assertDistributedPropertyEquals("historical.rebalance.threshold", 500, true);
        int newVal = 1000;
        GridCommandHandlerPropertiesTest.assertEquals((int)0, (int)this.execute("--property", "set", "--name", "historical.rebalance.threshold", "--val", Integer.toString(newVal)));
        this.assertDistributedPropertyEquals("historical.rebalance.threshold", newVal, true);
    }

    private <T extends Serializable> void assertDistributedPropertyEquals(String propName, T expected, boolean onlyServerMode) {
        for (Ignite ign : G.allGrids()) {
            IgniteEx ignEx = (IgniteEx)ign;
            if (onlyServerMode && ign.configuration().isClientMode().booleanValue()) continue;
            DistributedChangeableProperty prop = ignEx.context().distributedConfiguration().property(propName);
            GridCommandHandlerPropertiesTest.assertEquals((Object)prop.get(), expected);
        }
    }
}

